/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.register.route;

import java.util.Map;
import net.n2oapp.framework.api.MetadataEnvironment;
import net.n2oapp.framework.api.metadata.Compiled;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.meta.page.Page;
import net.n2oapp.framework.api.metadata.pipeline.ReadCompileTerminalPipeline;
import net.n2oapp.framework.api.register.route.MetadataRouter;
import net.n2oapp.framework.api.register.route.RouteInfoKey;
import net.n2oapp.framework.config.metadata.compile.N2oCompileProcessor;
import net.n2oapp.framework.config.metadata.compile.context.ApplicationContext;
import net.n2oapp.framework.config.metadata.compile.context.PageContext;
import net.n2oapp.framework.config.register.route.RouteNotFoundException;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;

public class N2oRouter
implements MetadataRouter {
    public static final String ROOT_ROUTE = "/";
    private MetadataEnvironment environment;
    private ReadCompileTerminalPipeline<?> pipeline;
    private final PathMatcher pathMatcher = new AntPathMatcher();

    public N2oRouter(MetadataEnvironment environment, ReadCompileTerminalPipeline<?> pipeline) {
        this.environment = environment;
        this.pipeline = pipeline;
    }

    public <D extends Compiled> CompileContext<D, ?> get(String url, Class<D> compiledClass, Map<String, String[]> params) {
        CompileContext<D, ?> result = this.findRoute(url = url != null ? url : ROOT_ROUTE, compiledClass);
        if (result != null) {
            return result;
        }
        if (this.environment.getRouteRegister().synchronize() && (result = this.findRoute(url, compiledClass)) != null) {
            return result;
        }
        this.tryToFindShallow(url, compiledClass, params);
        result = this.findRoute(url, compiledClass);
        if (result != null) {
            return result;
        }
        this.tryToFindDeep(url, params);
        result = this.findRoute(url, compiledClass);
        if (result == null) {
            this.tryToFindShallow(url, compiledClass, params);
            result = this.findRoute(url, compiledClass);
        }
        if (result != null) {
            return result;
        }
        throw new RouteNotFoundException(url);
    }

    private <D extends Compiled> CompileContext<D, ?> findRoute(String url, Class<D> compiledClass) {
        for (Map.Entry routeEntry : this.environment.getRouteRegister()) {
            PageContext pageContext;
            if (!compiledClass.isAssignableFrom(((CompileContext)routeEntry.getValue()).getCompiledClass())) continue;
            Object object = routeEntry.getValue();
            if (object instanceof PageContext && (pageContext = (PageContext)object).getSubRoutes() != null) {
                for (String subRoute : pageContext.getSubRoutes()) {
                    if (!this.pathMatcher.match(subRoute, url)) continue;
                    return (CompileContext)routeEntry.getValue();
                }
            }
            if (!this.pathMatcher.match(((RouteInfoKey)routeEntry.getKey()).getUrlMatching(), url)) continue;
            return (CompileContext)routeEntry.getValue();
        }
        return null;
    }

    private <D extends Compiled> void tryToFindShallow(String url, Class<D> compiledClass, Map<String, String[]> params) {
        if (Page.class == compiledClass) {
            return;
        }
        CompileContext<Page, ?> result = this.findRoute(url, Page.class);
        if (result != null) {
            this.pipeline.get(result, (CompileProcessor)new N2oCompileProcessor(this.environment, result, result.getParams(url, params)));
        }
    }

    private void tryToFindDeep(String url, Map<String, String[]> params) {
        if (url.length() > 1) {
            int idx = url.lastIndexOf(ROOT_ROUTE);
            String subUrl = idx > 0 ? url.substring(0, idx) : ROOT_ROUTE;
            CompileContext<Page, ?> result = this.findRoute(subUrl, Page.class);
            if (result == null) {
                this.tryToFindDeep(subUrl, params);
                result = this.findRoute(subUrl, Page.class);
            }
            if (result != null) {
                this.pipeline.get(result, (CompileProcessor)new N2oCompileProcessor(this.environment, result, result.getParams(url, params)));
            }
        } else {
            this.warmUpRootRoutes();
        }
    }

    private void warmUpRootRoutes() {
        String applicationId = (String)this.environment.getSystemProperties().getProperty("n2o.application.id", String.class);
        String welcomePageId = (String)this.environment.getSystemProperties().getProperty("n2o.homepage.id", String.class);
        if (applicationId != null && !applicationId.isEmpty()) {
            this.pipeline.get((CompileContext)new ApplicationContext(applicationId));
        } else if (welcomePageId != null && !welcomePageId.isEmpty()) {
            this.pipeline.get((CompileContext)new PageContext(welcomePageId, ROOT_ROUTE));
        }
    }
}

