/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.register.dynamic;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.n2oapp.framework.api.DynamicUtil;
import net.n2oapp.framework.api.metadata.SourceMetadata;
import net.n2oapp.framework.api.reader.SourceLoader;
import net.n2oapp.framework.api.register.DynamicMetadataProvider;
import net.n2oapp.framework.api.register.DynamicMetadataProviderFactory;
import net.n2oapp.framework.config.reader.MetadataNotFoundException;
import net.n2oapp.framework.config.register.JavaInfo;
import net.n2oapp.framework.config.register.dynamic.N2oDynamicMetadataProviderFactory;

public class JavaSourceLoader
implements SourceLoader<JavaInfo> {
    private DynamicMetadataProviderFactory providerFactory;
    private Consumer<SourceMetadata> cacheService;

    public JavaSourceLoader(DynamicMetadataProviderFactory providerFactory) {
        this.providerFactory = providerFactory;
    }

    public JavaSourceLoader(N2oDynamicMetadataProviderFactory providerFactory, Consumer<SourceMetadata> cacheService) {
        this(providerFactory);
        this.cacheService = cacheService;
    }

    public <S extends SourceMetadata> S load(JavaInfo info, String params) {
        return (S)this.readContent(info.getId(), info.getBaseSourceClass(), params);
    }

    private <T extends SourceMetadata> T readContent(String id, Class<T> metadataClass, String params) {
        Optional<SourceMetadata> optional;
        DynamicMetadataProvider provider = this.providerFactory.produce(id);
        List metadataList = provider.read(params);
        metadataList.stream().filter(m -> m.getId() == null).forEach(m -> m.setId(provider.getCode() + "?" + params));
        DynamicUtil.checkDynamicIds(metadataList.stream().map(SourceMetadata::getId).toList(), (String)provider.getCode());
        if (this.cacheService != null && provider.cache(params)) {
            this.cache(metadataList);
        }
        if ((optional = metadataList.stream().filter(m -> m.getId().equals(id + "?" + params)).filter(m -> metadataClass.isAssignableFrom(m.getClass())).findAny()).isPresent()) {
            return (T)optional.get();
        }
        throw new MetadataNotFoundException(id, metadataClass);
    }

    protected void cache(List<SourceMetadata> metadataList) {
        for (SourceMetadata metadata : metadataList) {
            this.cacheService.accept(metadata);
        }
    }

    public void setProviderFactory(N2oDynamicMetadataProviderFactory providerFactory) {
        this.providerFactory = providerFactory;
    }
}

