/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.register;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.n2oapp.framework.api.metadata.SourceMetadata;
import net.n2oapp.framework.api.register.MetaType;
import net.n2oapp.framework.api.register.SourceTypeRegister;
import net.n2oapp.framework.config.reader.MetaTypeNotFoundException;

public class N2oSourceTypeRegister
implements SourceTypeRegister {
    private Map<String, MetaType> register = new ConcurrentHashMap<String, MetaType>();

    public void add(MetaType metaType) {
        this.register.put(metaType.getSourceType(), metaType);
    }

    public void addAll(Collection<MetaType> metaType) {
        metaType.forEach(this::add);
    }

    public MetaType get(String sourceType) {
        if (!this.register.containsKey(sourceType)) {
            throw new MetaTypeNotFoundException(sourceType);
        }
        return this.register.get(sourceType);
    }

    public MetaType get(Class<? extends SourceMetadata> sourceClass) {
        for (MetaType metaType : this.register.values()) {
            if (!metaType.getBaseSourceClass().equals(sourceClass)) continue;
            return metaType;
        }
        for (MetaType metaType : this.register.values()) {
            if (!metaType.getBaseSourceClass().isAssignableFrom(sourceClass)) continue;
            return metaType;
        }
        throw new MetaTypeNotFoundException(sourceClass);
    }

    public void clearAll() {
        this.register.clear();
    }
}

