/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.register;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.register.ComponentTypeRegister;
import net.n2oapp.framework.config.reader.MetaTypeNotFoundException;

public class N2oComponentTypeRegister
implements ComponentTypeRegister {
    private final Map<String, Class<? extends Source>> typeClassMap = new ConcurrentHashMap<String, Class<? extends Source>>();
    private final Map<Class<? extends Source>, String> classTypeMap = new ConcurrentHashMap<Class<? extends Source>, String>();

    public void add(String type, Class<? extends Source> clazz) {
        this.typeClassMap.put(type, clazz);
        this.classTypeMap.put(clazz, type);
    }

    public void addAll(Map<String, Class<? extends Source>> componentTypes) {
        componentTypes.forEach(this::add);
    }

    public String getByClass(Class<? extends Source> clazz) {
        if (!this.classTypeMap.containsKey(clazz)) {
            throw new MetaTypeNotFoundException(clazz);
        }
        return this.classTypeMap.get(clazz);
    }

    public Class<? extends Source> getByType(String type) {
        if (!this.typeClassMap.containsKey(type)) {
            throw new MetaTypeNotFoundException(type);
        }
        return this.typeClassMap.get(type);
    }

    public void clearAll() {
        this.typeClassMap.clear();
        this.classTypeMap.clear();
    }
}

