/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.reader;

import java.io.File;
import java.io.IOException;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.reader.ConfigMetadataLocker;
import net.n2oapp.framework.config.register.storage.PathUtil;
import net.n2oapp.properties.StaticProperties;

public class ConfigMetadataLockerImpl
implements ConfigMetadataLocker {
    private String lockFileName;

    public ConfigMetadataLockerImpl() {
        this.lockFileName = PathUtil.concatAbsoluteAndLocalPath(StaticProperties.getProperty((String)"n2o.config.path"), "lock.tmp");
    }

    public ConfigMetadataLockerImpl(String configPath) {
        this.lockFileName = PathUtil.concatAbsoluteAndLocalPath(configPath, "lock.tmp");
    }

    public boolean isLocked() {
        File lockFile = new File(this.lockFileName);
        return lockFile.exists();
    }

    public void lock() {
        if (this.isLocked()) {
            throw new N2oException("Error in locking config metadata! One instance try to lock, when it has locked already by " + this.lockFileName + "!");
        }
        try {
            File lockFile = new File(this.lockFileName);
            lockFile.createNewFile();
        }
        catch (IOException e) {
            throw new N2oException("Error with lock config metadata! lockFileName = " + this.lockFileName, (Throwable)e);
        }
    }

    public void unlock() {
        File lockFile = new File(this.lockFileName);
        if (lockFile.exists()) {
            lockFile.delete();
        }
    }
}

