/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.properties;

import java.util.Map;
import java.util.NoSuchElementException;
import net.n2oapp.framework.api.StringUtils;
import org.springframework.core.env.PropertyResolver;

public class MutablePropertyResolver
implements PropertyResolver {
    private Map<String, String> properties;

    public MutablePropertyResolver(Map<String, String> properties) {
        this.properties = properties;
    }

    public boolean containsProperty(String key) {
        return this.properties.get(key) != null;
    }

    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public String getProperty(String key, String defaultValue) {
        String value = this.properties.get(key);
        return value != null ? value : defaultValue;
    }

    public <T> T getProperty(String key, Class<T> targetType) {
        String value = this.properties.get(key);
        return (T)value;
    }

    public <T> T getProperty(String key, Class<T> targetType, T defaultValue) {
        String value = this.properties.get(key);
        return (T)(value != null ? value : defaultValue);
    }

    public String getRequiredProperty(String key) throws IllegalStateException {
        String value = this.getProperty(key);
        if (value == null) {
            throw new NoSuchElementException(key);
        }
        return value;
    }

    public <T> T getRequiredProperty(String key, Class<T> targetType) throws IllegalStateException {
        T value = this.getProperty(key, targetType);
        if (value == null) {
            throw new NoSuchElementException(key);
        }
        return value;
    }

    public String resolvePlaceholders(String text) {
        return StringUtils.resolveProperties((String)text, this.properties);
    }

    public String resolveRequiredPlaceholders(String text) throws IllegalArgumentException {
        String value = this.resolvePlaceholders(text);
        if (value == null) {
            throw new NoSuchElementException(text);
        }
        return value;
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }
}

