/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.validation.standard.widget;

import java.util.Arrays;
import java.util.HashSet;
import java.util.function.Function;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.compile.SourceProcessor;
import net.n2oapp.framework.api.metadata.global.view.widget.table.N2oTable;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.N2oAbstractColumn;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.N2oBaseColumn;
import net.n2oapp.framework.api.metadata.global.view.widget.table.tablesettings.N2oColumnsTableSetting;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oGroup;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oSubmenu;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.ToolbarItem;
import net.n2oapp.framework.api.metadata.validation.exception.N2oMetadataValidationException;
import net.n2oapp.framework.config.metadata.compile.widget.MetaActions;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import net.n2oapp.framework.config.metadata.validation.standard.ValidationUtils;
import net.n2oapp.framework.config.metadata.validation.standard.widget.ListWidgetValidator;
import org.springframework.stereotype.Component;

@Component
public class TableValidator
extends ListWidgetValidator<N2oTable> {
    @Override
    public void validate(N2oTable source, SourceProcessor p) {
        super.validate(source, p);
        MetaActions actions = this.getAllMetaActions((MetaActions)p.getScope(MetaActions.class), source.getActions(), p);
        WidgetScope widgetScope = new WidgetScope(source.getId(), source.getDatasourceId(), source.getDatasource(), actions);
        if (source.getRows() != null && source.getRows().getRowClick() != null) {
            Arrays.stream(source.getRows().getRowClick().getActions()).forEach(item -> p.validate((Source)item, new Object[]{widgetScope}));
            ValidationUtils.checkOnFailAction(source.getRows().getRowClick().getActions());
        }
        if (source.getColumns() != null) {
            N2oBaseColumn[] columns = (N2oBaseColumn[])Arrays.stream(source.getColumns()).filter(N2oBaseColumn.class::isInstance).map(N2oBaseColumn.class::cast).toArray(N2oBaseColumn[]::new);
            this.checkUniqueIds(columns, N2oAbstractColumn::getId, source.getId(), "id");
            this.checkUniqueIds(columns, N2oBaseColumn::getTextFieldId, source.getId(), "text-field-id");
            Arrays.stream(source.getColumns()).forEach(col -> p.validate((Source)col, new Object[]{widgetScope}));
        }
        if (source.getFilters() != null) {
            p.safeStreamOf((Object[])source.getFilters().getItems()).forEach(item -> p.validate((Source)item, new Object[]{widgetScope}));
        }
        TableValidator.checkEmptyToolbar(source);
        this.checkUniqueColumnsTableSetting(source);
    }

    private static void checkEmptyToolbar(N2oTable source) {
        if (source.getRows() != null && source.getRows().getRowOverlay() != null && source.getRows().getRowOverlay().getToolbar() != null && source.getRows().getRowOverlay().getToolbar().getGenerate() == null && source.getRows().getRowOverlay().getToolbar().getItems() == null) {
            throw new N2oMetadataValidationException(String.format("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u044b \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b \u0438\u043b\u0438 \u0430\u0442\u0440\u0438\u0431\u0443\u0442 'generate' \u0432 \u0442\u0443\u043b\u0431\u0430\u0440\u0435 \u0432 <overlay> \u0442\u0430\u0431\u043b\u0438\u0446\u044b %s", ValidationUtils.getIdOrEmptyString(source.getId())));
        }
    }

    private void checkUniqueColumnsTableSetting(N2oTable source) {
        if (source.getToolbars() == null) {
            return;
        }
        int[] counter = new int[1];
        Arrays.stream(source.getToolbars()).filter(toolbar -> toolbar.getItems() != null).forEach(toolbar -> this.countColumnsSettings(toolbar.getItems(), counter));
        if (counter[0] > 1) {
            throw new N2oMetadataValidationException(String.format("\u0412 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 %s \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 <ts:columns/>. \u0414\u043e\u043f\u0443\u0441\u043a\u0430\u0435\u0442\u0441\u044f \u0442\u043e\u043b\u044c\u043a\u043e \u043e\u0434\u0438\u043d \u044d\u043b\u0435\u043c\u0435\u043d\u0442.", ValidationUtils.getIdOrEmptyString(source.getId())));
        }
    }

    private void countColumnsSettings(ToolbarItem[] toolbarItems, int[] counter) {
        if (toolbarItems == null) {
            return;
        }
        for (ToolbarItem toolbarItem : toolbarItems) {
            if (toolbarItem instanceof N2oColumnsTableSetting) {
                counter[0] = counter[0] + 1;
                if (counter[0] <= 1) continue;
                return;
            }
            if (toolbarItem instanceof N2oSubmenu) {
                N2oSubmenu submenu = (N2oSubmenu)toolbarItem;
                this.countColumnsSettings((ToolbarItem[])submenu.getMenuItems(), counter);
                if (counter[0] <= 1) continue;
                return;
            }
            if (!(toolbarItem instanceof N2oGroup)) continue;
            N2oGroup group = (N2oGroup)toolbarItem;
            this.countColumnsSettings((ToolbarItem[])group.getItems(), counter);
            if (counter[0] <= 1) continue;
            return;
        }
    }

    private void checkUniqueIds(N2oBaseColumn[] columns, Function<N2oBaseColumn, String> function, String sourceId, String attributeName) {
        HashSet uniques = new HashSet();
        Arrays.stream(columns).forEach(col -> {
            String id = (String)function.apply((N2oBaseColumn)col);
            if (id != null) {
                if (uniques.contains(id)) {
                    throw new N2oMetadataValidationException(String.format("\u0422\u0430\u0431\u043b\u0438\u0446\u0430 %s \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043f\u043e\u0432\u0442\u043e\u0440\u044f\u044e\u0449\u0438\u0435\u0441\u044f \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f %s=\"%s\" \u0432 <column>", ValidationUtils.getIdOrEmptyString(sourceId), attributeName, id));
                }
                uniques.add(id);
            }
        });
    }

    public Class<? extends Source> getSourceClass() {
        return N2oTable.class;
    }
}

