/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.validation.standard.regions;

import java.util.Arrays;
import java.util.HashSet;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.compile.SourceProcessor;
import net.n2oapp.framework.api.metadata.global.view.page.N2oPage;
import net.n2oapp.framework.api.metadata.global.view.region.N2oSubPageRegion;
import net.n2oapp.framework.api.metadata.validation.exception.N2oMetadataValidationException;
import net.n2oapp.framework.config.metadata.validation.standard.ValidationUtils;
import net.n2oapp.framework.config.metadata.validation.standard.regions.AbstractRegionValidator;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.stereotype.Component;

@Component
public class SubPageRegionValidator
extends AbstractRegionValidator<N2oSubPageRegion> {
    public Class<? extends Source> getSourceClass() {
        return N2oSubPageRegion.class;
    }

    @Override
    public void validate(N2oSubPageRegion source, SourceProcessor p) {
        if (source.getDefaultPageId() != null) {
            this.validateDefaultPageId(source);
        }
        Arrays.stream(source.getPages()).forEach(page -> this.validatePage((N2oSubPageRegion.Page)page, p));
        HashSet<String> routes = new HashSet<String>();
        for (N2oSubPageRegion.Page page2 : source.getPages()) {
            if (routes.contains(page2.getRoute())) {
                throw new N2oMetadataValidationException(String.format("\u0412 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430\u0445 <sub-page> \u0443\u043a\u0430\u0437\u0430\u043d\u044b \u043f\u043e\u0432\u0442\u043e\u0440\u044f\u044e\u0449\u0438\u0435\u0441\u044f \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u044b \"%s\"", page2.getRoute()));
            }
            routes.add(page2.getRoute());
        }
        super.validate(source, p);
    }

    private void validatePage(N2oSubPageRegion.Page page, SourceProcessor p) {
        if (page.getPageId() == null) {
            throw new N2oMetadataValidationException("\u0412 \u043e\u0434\u043d\u043e\u043c \u0438\u0437 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 <sub-page> \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u0430\u0442\u0440\u0438\u0431\u0443\u0442 'page-id'");
        }
        if (page.getRoute() == null) {
            throw new N2oMetadataValidationException("\u0412 \u043e\u0434\u043d\u043e\u043c \u0438\u0437 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 <sub-page> \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u0430\u0442\u0440\u0438\u0431\u0443\u0442 'route'");
        }
        p.checkForExists(page.getPageId(), N2oPage.class, String.format("\u041e\u0434\u0438\u043d \u0438\u0437 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 <sub-page> \u0441\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0443\u044e \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0443 %s", ValidationUtils.getIdOrEmptyString(page.getPageId())));
        SubPageRegionValidator.checkEmptyToolbar(page);
    }

    private void validateDefaultPageId(N2oSubPageRegion source) {
        for (N2oSubPageRegion.Page page : source.getPages()) {
            if (!page.getPageId().equals(source.getDefaultPageId())) continue;
            return;
        }
        throw new N2oMetadataValidationException("\u0412 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0435 'default-page-id' \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430 <sub-page> \u0443\u043a\u0430\u0437\u0430\u043d\u0430 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430, \u043a\u043e\u0442\u043e\u0440\u0430\u044f \u043d\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u043d\u0438 \u0432 \u043e\u0434\u043d\u043e\u043c \u0438\u0437 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0438\u0445 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 <page>");
    }

    private static void checkEmptyToolbar(N2oSubPageRegion.Page source) {
        Object[] toolbars = source.getToolbars();
        if (ArrayUtils.isNotEmpty((Object[])toolbars)) {
            for (Object toolbar : toolbars) {
                if (toolbar.getItems() != null || toolbar.getGenerate() != null) continue;
                throw new N2oMetadataValidationException(String.format("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u044b \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b \u0438\u043b\u0438 \u0430\u0442\u0440\u0438\u0431\u0443\u0442 'generate' \u0432 \u0442\u0443\u043b\u0431\u0430\u0440\u0435 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430 <sub-page> %s", ValidationUtils.getIdOrEmptyString(source.getPageId())));
            }
        }
    }
}

