/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.validation.standard.page;

import java.util.Collection;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.SourceClassAware;
import net.n2oapp.framework.api.metadata.compile.SourceProcessor;
import net.n2oapp.framework.api.metadata.global.view.page.N2oSearchablePage;
import net.n2oapp.framework.api.metadata.validate.SourceValidator;
import net.n2oapp.framework.api.metadata.validation.exception.N2oMetadataValidationException;
import net.n2oapp.framework.config.metadata.validation.standard.ValidatorDatasourceIdsScope;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class SearchablePageValidator
implements SourceValidator<N2oSearchablePage>,
SourceClassAware {
    public Class<? extends Source> getSourceClass() {
        return N2oSearchablePage.class;
    }

    public void validate(N2oSearchablePage page, SourceProcessor p) {
        ValidatorDatasourceIdsScope datasourceIdsScope = new ValidatorDatasourceIdsScope();
        p.safeStreamOf((Object[])page.getDatasources()).forEach(datasource -> datasourceIdsScope.add(datasource.getId()));
        p.safeStreamOf((Collection)page.getWidgets()).filter(widget -> widget.getDatasourceId() == null).forEach(widget -> datasourceIdsScope.add(widget.getId()));
        this.checkSearchBar(page, datasourceIdsScope);
    }

    private void checkSearchBar(N2oSearchablePage page, ValidatorDatasourceIdsScope datasourceIdsScope) {
        this.checkDatasource(page, datasourceIdsScope);
        this.checkFilters(page);
    }

    private void checkDatasource(N2oSearchablePage page, ValidatorDatasourceIdsScope datasourceIdsScope) {
        if (page.getSearchBar() != null) {
            if (page.getSearchBar().getDatasourceId() == null) {
                throw new N2oMetadataValidationException(String.format("\u0414\u043b\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b '%s' \u0441 \u043f\u043e\u0438\u0441\u043a\u043e\u0432\u043e\u0439 \u0441\u0442\u0440\u043e\u043a\u043e\u0439 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0443\u043a\u0430\u0437\u0430\u0442\u044c \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445 \u0432 <search-bar>", page.getId()));
            }
            this.checkDatasourceLink(page.getSearchBar().getDatasourceId(), datasourceIdsScope, String.format("\u042d\u043b\u0435\u043c\u0435\u043d\u0442 <search-bar> \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b '%s' \u0441 \u043f\u043e\u0438\u0441\u043a\u043e\u0432\u043e\u0439 \u0441\u0442\u0440\u043e\u043a\u043e\u0439 \u0441\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445 '%s'", page.getId(), page.getSearchBar().getDatasourceId()));
        }
    }

    private void checkFilters(N2oSearchablePage page) {
        if (StringUtils.isBlank((CharSequence)page.getSearchBar().getSearchFilterId())) {
            throw new N2oMetadataValidationException(String.format("\u0414\u043b\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b '%s' \u0441 \u043f\u043e\u0438\u0441\u043a\u043e\u0432\u043e\u0439 \u0441\u0442\u0440\u043e\u043a\u043e\u0439 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0443\u043a\u0430\u0437\u0430\u0442\u044c \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0444\u0438\u043b\u044c\u0442\u0440\u0430 'search-filter-id' \u0432 <search-bar>", page.getId()));
        }
    }

    private void checkDatasourceLink(String datasourceId, ValidatorDatasourceIdsScope datasourceIdsScope, String errorMessage) {
        if (datasourceIdsScope == null || !datasourceIdsScope.contains(datasourceId)) {
            throw new N2oMetadataValidationException(errorMessage);
        }
    }
}

