/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.validation.standard.datasource;

import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.compile.SourceProcessor;
import net.n2oapp.framework.api.metadata.global.view.page.datasource.N2oInheritedDatasource;
import net.n2oapp.framework.api.metadata.validation.exception.N2oMetadataValidationException;
import net.n2oapp.framework.config.metadata.validation.standard.ValidationUtils;
import net.n2oapp.framework.config.metadata.validation.standard.datasource.DatasourceValidator;
import org.springframework.stereotype.Component;

@Component
public class InheritedDatasourceValidator
extends DatasourceValidator<N2oInheritedDatasource> {
    public Class<? extends Source> getSourceClass() {
        return N2oInheritedDatasource.class;
    }

    @Override
    public void validate(N2oInheritedDatasource source, SourceProcessor p) {
        super.validate(source, p);
        this.checkSourceDatasource(source, p);
    }

    private void checkSourceDatasource(N2oInheritedDatasource source, SourceProcessor p) {
        String sourceDatasource = source.getSourceDatasource();
        if (sourceDatasource == null) {
            throw new N2oMetadataValidationException(String.format("\u0412 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 %s \u043d\u0435 \u0437\u0430\u0434\u0430\u043d \u0430\u0442\u0440\u0438\u0431\u0443\u0442 'source-datasource'", ValidationUtils.getIdOrEmptyString(source.getId())));
        }
        if (sourceDatasource.equals(source.getId())) {
            throw new N2oMetadataValidationException(String.format("\u0410\u0442\u0440\u0438\u0431\u0443\u0442 'source-datasource' \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 %s \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0435\u0442 \u0441 'id'", ValidationUtils.getIdOrEmptyString(source.getId())));
        }
        ValidationUtils.checkDatasourceExistence(sourceDatasource, p, String.format("\u0412 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 %s \u0430\u0442\u0440\u0438\u0431\u0443\u0442 'source-datasource' \u0441\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445 %s", ValidationUtils.getIdOrEmptyString(source.getId()), ValidationUtils.getIdOrEmptyString(source.getSourceDatasource())));
    }
}

