/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.validation.standard.datasource;

import net.n2oapp.framework.api.metadata.compile.SourceProcessor;
import net.n2oapp.framework.api.metadata.global.view.page.datasource.N2oDatasource;
import net.n2oapp.framework.api.metadata.validation.exception.N2oMetadataValidationException;
import net.n2oapp.framework.config.metadata.compile.page.PageScope;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import net.n2oapp.framework.config.metadata.validation.standard.ValidationUtils;
import net.n2oapp.framework.config.metadata.validation.standard.datasource.AbstractDatasourceValidator;

public abstract class DatasourceValidator<S extends N2oDatasource>
extends AbstractDatasourceValidator<S> {
    @Override
    public void validate(S source, SourceProcessor p) {
        PageScope pageScope = (PageScope)p.getScope(PageScope.class);
        WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
        if (source.getId() == null && widgetScope == null) {
            throw new N2oMetadataValidationException(String.format("\u0412 \u043e\u0434\u043d\u043e\u043c \u0438\u0437 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u043e\u0432 \u0434\u0430\u043d\u043d\u044b\u0445 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b %s \u043d\u0435 \u0437\u0430\u0434\u0430\u043d 'id'", ValidationUtils.getIdOrEmptyString(pageScope.getPageId())));
        }
        this.checkDependencies(source, p);
    }

    private void checkDependencies(S datasource, SourceProcessor p) {
        if (datasource.getDependencies() != null) {
            for (N2oDatasource.Dependency d : datasource.getDependencies()) {
                if (d.getOn() == null) {
                    throw new N2oMetadataValidationException(String.format("\u0412 \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u0438 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 %s \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u0430\u0442\u0440\u0438\u0431\u0443\u0442 'on'", ValidationUtils.getIdOrEmptyString(datasource.getId())));
                }
                if (d.getOn() == null) continue;
                String on = d.getOn();
                ValidationUtils.checkDatasourceExistence(on, p, String.format("\u0410\u0442\u0440\u0438\u0431\u0443\u0442 'on' \u0432 \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u0438 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 %s \u0441\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445 '%s'", ValidationUtils.getIdOrEmptyString(datasource.getId()), on));
            }
        }
    }
}

