/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.validation.standard.datasource;

import java.util.regex.Pattern;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.compile.SourceProcessor;
import net.n2oapp.framework.api.metadata.global.dao.query.N2oQuery;
import net.n2oapp.framework.api.metadata.global.view.page.datasource.N2oCachedDatasource;
import net.n2oapp.framework.api.metadata.validation.exception.N2oMetadataValidationException;
import net.n2oapp.framework.config.metadata.validation.standard.ValidationUtils;
import net.n2oapp.framework.config.metadata.validation.standard.datasource.AbstractDatasourceValidator;
import org.springframework.stereotype.Component;

@Component
public class CachedDatasourceValidator
extends AbstractDatasourceValidator<N2oCachedDatasource> {
    private static final Pattern CACHES_EXPIRES_PATTERN = Pattern.compile("^(\\d+d\\s*)?(\\d+h\\s*)?(\\d+m)?$");

    public Class<? extends Source> getSourceClass() {
        return N2oCachedDatasource.class;
    }

    @Override
    public void validate(N2oCachedDatasource datasource, SourceProcessor p) {
        super.validate(datasource, p);
        ValidationUtils.checkForExistsObject(datasource.getObjectId(), String.format("\u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445 %s", ValidationUtils.getIdOrEmptyString(datasource.getId())), p);
        N2oQuery query = ValidationUtils.checkQueryExists(datasource.getQueryId(), String.format("\u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445 %s", ValidationUtils.getIdOrEmptyString(datasource.getId())), p);
        this.checkSubmit(datasource.getId(), datasource.getSubmit(), p);
        this.checkPrefilters(datasource.getId(), datasource.getFilters(), query, p);
        if (datasource.getCacheExpires() != null && !CACHES_EXPIRES_PATTERN.matcher(datasource.getCacheExpires()).matches()) {
            throw new N2oMetadataValidationException(String.format("\u041f\u0435\u0440\u0438\u043e\u0434\u0438\u0447\u043d\u043e\u0441\u0442\u044c \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u043a\u044d\u0448\u0430 \u0432 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 %s \u0443\u043a\u0430\u0437\u0430\u043d\u0430 \u0432 \u043d\u0435\u0432\u0435\u0440\u043d\u043e\u043c \u0444\u043e\u0440\u043c\u0430\u0442\u0435", ValidationUtils.getIdOrEmptyString(datasource.getId())));
        }
    }
}

