/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.validation.standard.datasource;

import java.util.Arrays;
import java.util.Objects;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.application.N2oApplication;
import net.n2oapp.framework.api.metadata.compile.SourceProcessor;
import net.n2oapp.framework.api.metadata.global.view.page.datasource.N2oApplicationDatasource;
import net.n2oapp.framework.api.metadata.validation.exception.N2oMetadataValidationException;
import net.n2oapp.framework.config.metadata.validation.standard.datasource.AbstractDatasourceValidator;
import org.springframework.stereotype.Component;

@Component
public class ApplicationDatasourceValidator
extends AbstractDatasourceValidator<N2oApplicationDatasource> {
    public Class<? extends Source> getSourceClass() {
        return N2oApplicationDatasource.class;
    }

    @Override
    public void validate(N2oApplicationDatasource datasource, SourceProcessor p) {
        super.validate(datasource, p);
        N2oApplication n2oApplication = (N2oApplication)p.getSource((String)p.resolve("${n2o.application.id}", String.class), N2oApplication.class);
        if (Objects.isNull(n2oApplication.getDatasources()) || Arrays.stream(n2oApplication.getDatasources()).noneMatch(ds -> ds.getId().equals(this.getDatasourceId(datasource)))) {
            throw new N2oMetadataValidationException(String.format("\u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445 <app-datasource> \u0441\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u0432 %s.application.xml \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445 '%s'", n2oApplication.getId(), this.getDatasourceId(datasource)));
        }
    }

    private String getDatasourceId(N2oApplicationDatasource datasource) {
        return datasource.getSourceDatasource() == null ? datasource.getId() : datasource.getSourceDatasource();
    }
}

