/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.validation.standard.control;

import java.util.Map;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.compile.SourceProcessor;
import net.n2oapp.framework.api.metadata.control.N2oMarkdown;
import net.n2oapp.framework.api.metadata.validation.TypedMetadataValidator;
import net.n2oapp.framework.api.metadata.validation.exception.N2oMetadataValidationException;
import net.n2oapp.framework.config.metadata.compile.widget.MetaActions;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class MarkdownValidator
extends TypedMetadataValidator<N2oMarkdown> {
    public Class<? extends Source> getSourceClass() {
        return N2oMarkdown.class;
    }

    public void validate(N2oMarkdown source, SourceProcessor p) {
        if (!ArrayUtils.isEmpty((Object[])source.getActionIds())) {
            MetaActions metaActions = this.getMetaActions(p);
            if (CollectionUtils.isEmpty((Map)metaActions)) {
                throw new N2oMetadataValidationException(String.format("\u0414\u043b\u044f \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u0430 \u0441 actions=\"%s\" \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f <actions>", String.join((CharSequence)",", source.getActionIds())));
            }
            for (String actionId : source.getActionIds()) {
                if (metaActions.containsKey(actionId)) continue;
                throw new N2oMetadataValidationException(String.format("\u041a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442 \u0441 actions \"%s\" \u0441\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0435\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0435", actionId));
            }
        }
    }

    private MetaActions getMetaActions(SourceProcessor p) {
        MetaActions metaActions;
        MetaActions pageActions = (MetaActions)p.getScope(MetaActions.class);
        WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
        MetaActions metaActions2 = metaActions = widgetScope == null || widgetScope.getActions() == null ? new MetaActions() : widgetScope.getActions();
        if (!CollectionUtils.isEmpty((Map)pageActions)) {
            metaActions.putAll(pageActions);
        }
        return metaActions;
    }
}

