/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.validation.standard.control;

import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.SourceClassAware;
import net.n2oapp.framework.api.metadata.compile.SourceProcessor;
import net.n2oapp.framework.api.metadata.control.N2oListField;
import net.n2oapp.framework.api.metadata.validate.SourceValidator;
import net.n2oapp.framework.api.metadata.validation.exception.N2oMetadataValidationException;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import net.n2oapp.framework.config.metadata.validation.standard.ValidationUtils;
import org.springframework.stereotype.Component;

@Component
public class ListFieldValidator
implements SourceValidator<N2oListField>,
SourceClassAware {
    public void validate(N2oListField field, SourceProcessor p) {
        WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
        ValidationUtils.checkQueryExists(field.getQueryId(), String.format("\u041f\u043e\u043b\u0435 %s", ValidationUtils.getIdOrEmptyString(field.getId())), p);
        if (field.getQueryId() != null && field.getDatasourceId() != null) {
            throw new N2oMetadataValidationException(String.format("\u041f\u043e\u043b\u0435 '%s' \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442 \u0432\u044b\u0431\u043e\u0440\u043a\u0443 \u0438 \u0441\u0441\u044b\u043b\u043a\u0443 \u043d\u0430 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445 \u043e\u0434\u043d\u043e\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e", field.getId()));
        }
        if (field.getQueryId() != null && field.getOptions() != null) {
            throw new N2oMetadataValidationException(String.format("\u041f\u043e\u043b\u0435 '%s' \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442 \u0432\u044b\u0431\u043e\u0440\u043a\u0443 \u0438 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 '<options>' \u043e\u0434\u043d\u043e\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e", field.getId()));
        }
        if (field.getDatasourceId() != null && field.getOptions() != null) {
            throw new N2oMetadataValidationException(String.format("\u041f\u043e\u043b\u0435 '%s' \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442 \u0441\u0441\u044b\u043b\u043a\u0443 \u043d\u0430 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445 \u0438 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 '<options>' \u043e\u0434\u043d\u043e\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e", field.getId()));
        }
        if (field.getDatasourceId() != null) {
            this.checkDatasource(field, widgetScope, p);
        }
    }

    private void checkDatasource(N2oListField source, WidgetScope widgetScope, SourceProcessor p) {
        ValidationUtils.checkDatasourceExistence(source.getDatasourceId(), p, String.format("\u0423\u043a\u0430\u0437\u0430\u043d \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445 %s \u0434\u043b\u044f \u043f\u043e\u043b\u044f %s \u0432\u0438\u0434\u0436\u0435\u0442\u0430 %s", ValidationUtils.getIdOrEmptyString(source.getDatasourceId()), ValidationUtils.getIdOrEmptyString(source.getId()), ValidationUtils.getIdOrEmptyString(widgetScope.getWidgetId())));
    }

    public Class<? extends Source> getSourceClass() {
        return N2oListField.class;
    }
}

