/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.validation.standard.control;

import java.util.HashSet;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.NamespaceUriAware;
import net.n2oapp.framework.api.metadata.aware.SourceClassAware;
import net.n2oapp.framework.api.metadata.compile.SourceProcessor;
import net.n2oapp.framework.api.metadata.control.N2oField;
import net.n2oapp.framework.api.metadata.control.N2oListField;
import net.n2oapp.framework.api.metadata.control.PageRefEnum;
import net.n2oapp.framework.api.metadata.control.interval.N2oSimpleIntervalField;
import net.n2oapp.framework.api.metadata.global.view.page.datasource.N2oStandardDatasource;
import net.n2oapp.framework.api.metadata.validate.SourceValidator;
import net.n2oapp.framework.api.metadata.validation.exception.N2oMetadataValidationException;
import net.n2oapp.framework.config.metadata.compile.datasource.ValidatorDataSourcesScope;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import net.n2oapp.framework.config.metadata.validation.standard.ValidationUtils;
import net.n2oapp.framework.config.metadata.validation.standard.widget.FieldsScope;
import org.springframework.stereotype.Component;

@Component
public class FieldValidator
implements SourceValidator<N2oField>,
SourceClassAware {
    public void validate(N2oField source, SourceProcessor p) {
        ValidationUtils.checkId((NamespaceUriAware)source, p);
        WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
        if (p.getScope(FieldsScope.class) != null) {
            FieldsScope scope = (FieldsScope)p.getScope(FieldsScope.class);
            Boolean sameFieldIdHasDependency = (Boolean)scope.get(source.getId());
            if (sameFieldIdHasDependency != null && (sameFieldIdHasDependency.booleanValue() || source.getDependencies() != null)) {
                throw new N2oMetadataValidationException(String.format("\u041f\u043e\u043b\u0435 %s \u0432\u0441\u0442\u0440\u0435\u0447\u0430\u0435\u0442\u0441\u044f \u0431\u043e\u043b\u0435\u0435 \u043e\u0434\u043d\u043e\u0433\u043e \u0440\u0430\u0437\u0430", ValidationUtils.getIdOrEmptyString(source.getId())));
            }
            scope.put(source.getId(), source.getDependencies() != null);
        }
        this.checkDefaultValues(source);
        this.checkDependencies(source);
        this.checkRefDatasource(source, p);
        if (widgetScope != null) {
            this.checkWhiteListValidation(source, widgetScope, p);
        }
        if (source.getToolbar() != null) {
            p.safeStreamOf((Object[])source.getToolbar().getItems()).forEach(x$0 -> p.validate(x$0, new Object[0]));
        }
        FieldValidator.checkEmptyToolbar(source);
    }

    private static void checkEmptyToolbar(N2oField source) {
        if (source.getToolbar() != null && source.getToolbar().getItems() == null) {
            throw new N2oMetadataValidationException(String.format("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u044b \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b \u0438\u043b\u0438 \u0430\u0442\u0440\u0438\u0431\u0443\u0442 'generate' \u0432 \u0442\u0443\u043b\u0431\u0430\u0440\u0435 \u043f\u043e\u043b\u044f %s", ValidationUtils.getIdOrEmptyString(source.getId())));
        }
    }

    private void checkDefaultValues(N2oField source) {
        if ((source.getRefPage() != null || source.getRefDatasourceId() != null || source.getRefModel() != null) && source.getRefFieldId() == null) {
            if (source instanceof N2oListField) {
                N2oListField list = (N2oListField)source;
                this.checkListFieldDefaultValues(list);
            } else if (source instanceof N2oSimpleIntervalField) {
                N2oSimpleIntervalField interval = (N2oSimpleIntervalField)source;
                if (interval.getBegin() == null && interval.getEnd() == null) {
                    throw new N2oMetadataValidationException(String.format("\u0423 \u043f\u043e\u043b\u044f %s default-value \u043d\u0435 \u0437\u0430\u0434\u0430\u043d", ValidationUtils.getIdOrEmptyString(source.getId())));
                }
                if (!StringUtils.isLink((Object)interval.getBegin()) && !StringUtils.isLink((Object)interval.getEnd())) {
                    throw new N2oMetadataValidationException(String.format("\u0423 \u043f\u043e\u043b\u044f %s default-value \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0441\u0441\u044b\u043b\u043a\u043e\u0439", ValidationUtils.getIdOrEmptyString(source.getId())));
                }
            } else if (!StringUtils.isLink((Object)source.getDefaultValue())) {
                throw new N2oMetadataValidationException(String.format("\u0423 \u043f\u043e\u043b\u044f %s \u0430\u0442\u0440\u0438\u0431\u0443\u0442 default-value \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0441\u0441\u044b\u043b\u043a\u043e\u0439 \u0438\u043b\u0438 \u043d\u0435 \u0437\u0430\u0434\u0430\u043d: '%s'", ValidationUtils.getIdOrEmptyString(source.getId()), source.getDefaultValue()));
            }
        }
    }

    private void checkListFieldDefaultValues(N2oListField list) {
        if (list.getDefValue() != null && list.getDefValue().values().stream().filter(StringUtils::isLink).findFirst().isEmpty()) {
            throw new N2oMetadataValidationException(String.format("\u0423 \u043f\u043e\u043b\u044f %s default-value \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0441\u0441\u044b\u043b\u043a\u043e\u0439", ValidationUtils.getIdOrEmptyString(list.getId())));
        }
    }

    private void checkDependencies(N2oField source) {
        if (source.getDependencies() != null) {
            HashSet dependencyClasses = new HashSet();
            for (N2oField.Dependency dependency : source.getDependencies()) {
                if (N2oField.SetValueDependency.class.equals(dependency.getClass()) || dependencyClasses.add(dependency.getClass())) continue;
                throw new N2oMetadataValidationException(String.format("\u0412 \u043f\u043e\u043b\u0435 %s \u043f\u043e\u0432\u0442\u043e\u0440\u044f\u044e\u0442\u0441\u044f \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u0438 \u043e\u0434\u043d\u043e\u0433\u043e \u0442\u0438\u043f\u0430", ValidationUtils.getIdOrEmptyString(source.getId())));
            }
        }
    }

    private void checkRefDatasource(N2oField source, SourceProcessor p) {
        if (source.getRefDatasourceId() != null && PageRefEnum.THIS.equals((Object)source.getRefPage())) {
            ValidationUtils.checkDatasourceExistence(source.getRefDatasourceId(), p, String.format("\u0412 \u0441\u0441\u044b\u043b\u043a\u0435 \u043d\u0430 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445 \u043f\u043e\u043b\u044f %s \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442\u0441\u044f \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445 '%s'", ValidationUtils.getIdOrEmptyString(source.getId()), source.getRefDatasourceId()));
        }
    }

    private void checkWhiteListValidation(N2oField source, WidgetScope widgetScope, SourceProcessor p) {
        N2oField.Validations validations = source.getValidations();
        if (validations != null && validations.getWhiteList() != null) {
            if (widgetScope.getInLineDatasource() != null) {
                this.checkInlineDatasource(source, widgetScope);
                return;
            }
            this.checkDatasource(source, widgetScope, p);
        }
    }

    private void checkInlineDatasource(N2oField source, WidgetScope widgetScope) {
        this.checkDatasourceObject(source, widgetScope.getInLineDatasource(), widgetScope);
    }

    private void checkDatasource(N2oField source, WidgetScope widgetScope, SourceProcessor p) {
        Object v;
        if (widgetScope.getDatasourceId() == null) {
            throw new N2oMetadataValidationException(String.format("\u0414\u043b\u044f \u043a\u043e\u043c\u043f\u0438\u043b\u044f\u0446\u0438\u0438 \u043f\u043e\u043b\u044f %s \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0443\u043a\u0430\u0437\u0430\u0442\u044c \u0430\u0442\u0440\u0438\u0431\u0443\u0442 'datasource' \u0438\u043b\u0438 \u0432\u0432\u0435\u0441\u0442\u0438 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0438\u0439 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445 \u0432\u0438\u0434\u0436\u0435\u0442\u0430 %s", ValidationUtils.getIdOrEmptyString(source.getId()), ValidationUtils.getIdOrEmptyString(widgetScope.getWidgetId())));
        }
        ValidatorDataSourcesScope dataSourcesScope = (ValidatorDataSourcesScope)p.getScope(ValidatorDataSourcesScope.class);
        if (dataSourcesScope != null && (v = dataSourcesScope.get(widgetScope.getDatasourceId())) instanceof N2oStandardDatasource) {
            N2oStandardDatasource standardDatasource = (N2oStandardDatasource)v;
            this.checkDatasourceObject(source, standardDatasource, widgetScope);
        }
    }

    private void checkDatasourceObject(N2oField source, N2oStandardDatasource datasource, WidgetScope widgetScope) {
        if (datasource.getObjectId() == null) {
            throw new N2oMetadataValidationException(String.format("\u0414\u043b\u044f \u043a\u043e\u043c\u043f\u0438\u043b\u044f\u0446\u0438\u0438 \u043f\u043e\u043b\u044f %s \u0432\u0438\u0434\u0436\u0435\u0442\u0430 %s \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0443\u043a\u0430\u0437\u0430\u0442\u044c \u043e\u0431\u044a\u0435\u043a\u0442 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 %s", ValidationUtils.getIdOrEmptyString(source.getId()), ValidationUtils.getIdOrEmptyString(widgetScope.getWidgetId()), ValidationUtils.getIdOrEmptyString(datasource.getId())));
        }
    }

    public Class<? extends Source> getSourceClass() {
        return N2oField.class;
    }
}

