/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.validation.standard.cell;

import java.util.Arrays;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.SourceClassAware;
import net.n2oapp.framework.api.metadata.compile.SourceProcessor;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.cell.N2oToolbarCell;
import net.n2oapp.framework.api.metadata.validate.SourceValidator;
import net.n2oapp.framework.api.metadata.validation.exception.N2oMetadataValidationException;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import net.n2oapp.framework.config.metadata.validation.standard.ValidationUtils;
import org.springframework.stereotype.Component;

@Component
public class ToolbarCellValidator
implements SourceValidator<N2oToolbarCell>,
SourceClassAware {
    public Class<? extends Source> getSourceClass() {
        return N2oToolbarCell.class;
    }

    public void validate(N2oToolbarCell source, SourceProcessor p) {
        if (source.getItems() != null) {
            Arrays.stream(source.getItems()).forEach(x$0 -> p.validate(x$0, new Object[0]));
        }
        ToolbarCellValidator.checkEmptyToolbar(source, p);
    }

    private static void checkEmptyToolbar(N2oToolbarCell source, SourceProcessor p) {
        WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
        if (source.getGenerate() == null && source.getItems() == null) {
            throw new N2oMetadataValidationException(String.format("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u044b \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b \u0438\u043b\u0438 \u0430\u0442\u0440\u0438\u0431\u0443\u0442 'generate' \u0432 <toolbar> \u044f\u0447\u0435\u0439\u043a\u0435 \u0432\u0438\u0434\u0436\u0435\u0442\u0430 %s", ValidationUtils.getIdOrEmptyString(widgetScope.getWidgetId())));
        }
    }
}

