/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.validation.standard.button;

import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.SourceClassAware;
import net.n2oapp.framework.api.metadata.compile.SourceProcessor;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.Button;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oButton;
import net.n2oapp.framework.api.metadata.validate.SourceValidator;
import net.n2oapp.framework.config.metadata.validation.standard.ValidationUtils;
import org.springframework.stereotype.Component;

@Component
public class ButtonValidator
implements SourceValidator<N2oButton>,
SourceClassAware {
    public Class<? extends Source> getSourceClass() {
        return N2oButton.class;
    }

    public void validate(N2oButton source, SourceProcessor p) {
        this.checkValidateDependenciesDatasource(source, p);
        ValidationUtils.checkOnFailAction(source.getActions());
    }

    private void checkValidateDependenciesDatasource(N2oButton source, SourceProcessor p) {
        if (source.getDependencies() != null) {
            for (N2oButton.Dependency dependency : source.getDependencies()) {
                if (dependency.getDatasource() == null) continue;
                ValidationUtils.checkDatasourceExistence(dependency.getDatasource(), p, String.format("\u0410\u0442\u0440\u0438\u0431\u0443\u0442 'datasource' \u0432 \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u044f\u0445 \u043a\u043d\u043e\u043f\u043a\u0438 %s \u0441\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445 '%s'", this.getLabelOrId((Button)source), dependency.getDatasource()));
            }
        }
    }

    private String getLabelOrId(Button button) {
        return ValidationUtils.getIdOrEmptyString(button.getLabel() != null ? button.getLabel() : button.getId());
    }
}

