/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.validation.standard.application;

import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.application.N2oSidebar;
import net.n2oapp.framework.api.metadata.aware.SourceClassAware;
import net.n2oapp.framework.api.metadata.compile.SourceProcessor;
import net.n2oapp.framework.api.metadata.global.view.page.datasource.N2oStandardDatasource;
import net.n2oapp.framework.api.metadata.validate.SourceValidator;
import net.n2oapp.framework.api.metadata.validation.exception.N2oMetadataValidationException;
import net.n2oapp.framework.config.metadata.compile.application.sidebar.SidebarPathsScope;
import net.n2oapp.framework.config.metadata.compile.datasource.ValidatorDataSourcesScope;
import net.n2oapp.framework.config.metadata.validation.standard.ValidationUtils;
import net.n2oapp.framework.config.metadata.validation.standard.ValidatorDatasourceIdsScope;
import org.springframework.stereotype.Component;

@Component
public class SidebarValidator
implements SourceValidator<N2oSidebar>,
SourceClassAware {
    public Class<? extends Source> getSourceClass() {
        return N2oSidebar.class;
    }

    public void validate(N2oSidebar sidebar, SourceProcessor p) {
        if (sidebar.getMenu() != null) {
            p.validate((Source)sidebar.getMenu(), new Object[]{p.getScope(ValidatorDatasourceIdsScope.class)});
        }
        if (sidebar.getExtraMenu() != null) {
            p.validate((Source)sidebar.getExtraMenu(), new Object[]{p.getScope(ValidatorDatasourceIdsScope.class)});
        }
        ValidatorDataSourcesScope dataSourcesScope = (ValidatorDataSourcesScope)p.getScope(ValidatorDataSourcesScope.class);
        if (sidebar.getDatasource() != null) {
            if (sidebar.getDatasourceId() != null) {
                throw new N2oMetadataValidationException(String.format("\u0421\u0430\u0439\u0434\u0431\u0430\u0440 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0438\u0439 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445 \u0438 \u0441\u0441\u044b\u043b\u043a\u0443 \u043d\u0430 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445 %s \u043e\u0434\u043d\u043e\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e", ValidationUtils.getIdOrEmptyString(sidebar.getDatasourceId())));
            }
            N2oStandardDatasource datasource = sidebar.getDatasource();
            if (dataSourcesScope != null && dataSourcesScope.containsKey(datasource.getId())) {
                throw new N2oMetadataValidationException(String.format("\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 %s \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 \u0441\u0430\u0439\u0434\u0431\u0430\u0440\u0430 \u0443\u0436\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0434\u0440\u0443\u0433\u0438\u043c \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u043e\u043c \u0434\u0430\u043d\u043d\u044b\u0445", ValidationUtils.getIdOrEmptyString(datasource.getId())));
            }
        }
        if (sidebar.getDatasourceId() != null) {
            ValidationUtils.checkDatasourceExistence(sidebar.getDatasourceId(), p, String.format("\u0421\u0430\u0439\u0434\u0431\u0430\u0440 \u0441\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445 %s", ValidationUtils.getIdOrEmptyString(sidebar.getDatasourceId())));
        }
        this.checkPath(sidebar, (SidebarPathsScope)p.getScope(SidebarPathsScope.class));
    }

    private void checkPath(N2oSidebar sidebar, SidebarPathsScope scope) {
        if (scope == null) {
            return;
        }
        String sidebarPath = sidebar.getPath();
        if (scope.contains(sidebarPath)) {
            String errorMessage = sidebarPath == null ? "\u041f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u0438\u043c\u0435\u0435\u0442 \u0431\u043e\u043b\u0435\u0435 \u043e\u0434\u043d\u043e\u0433\u043e <sidebar> \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0449\u0438\u0445 'path'" : String.format("\u0414\u0432\u0430 \u0438\u043b\u0438 \u0431\u043e\u043b\u0435\u0435 <sidebar> \u0438\u043c\u0435\u044e\u0442 \u043e\u0434\u0438\u043d\u0430\u043a\u043e\u0432\u044b\u0439 'path = %s'", sidebarPath);
            throw new N2oMetadataValidationException(errorMessage);
        }
        scope.add(sidebarPath);
    }
}

