/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.validation.standard.action;

import java.util.Arrays;
import java.util.Objects;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.action.N2oAbstractPageAction;
import net.n2oapp.framework.api.metadata.aware.SourceClassAware;
import net.n2oapp.framework.api.metadata.compile.SourceProcessor;
import net.n2oapp.framework.api.metadata.global.dao.N2oParam;
import net.n2oapp.framework.api.metadata.global.dao.object.N2oObject;
import net.n2oapp.framework.api.metadata.global.view.page.N2oPage;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oToolbar;
import net.n2oapp.framework.api.metadata.validate.SourceValidator;
import net.n2oapp.framework.api.metadata.validation.exception.N2oMetadataValidationException;
import net.n2oapp.framework.config.metadata.compile.page.PageScope;
import net.n2oapp.framework.config.metadata.validation.standard.ValidationUtils;
import net.n2oapp.framework.config.metadata.validation.standard.ValidatorDatasourceIdsScope;
import org.springframework.stereotype.Component;

@Component
public class PageActionValidator
implements SourceValidator<N2oAbstractPageAction>,
SourceClassAware {
    public void validate(N2oAbstractPageAction source, SourceProcessor p) {
        ValidationUtils.checkForExistsObject(source.getObjectId(), String.format("\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u0435 \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b %s", ValidationUtils.getIdOrEmptyString(source.getId())), p);
        p.checkForExists(source.getPageId(), N2oPage.class, "\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u0435 \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b " + ValidationUtils.getIdOrEmptyString(source.getId()) + " \u0441\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0443\u044e \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0443 " + source.getPageId());
        if (source.getSubmitOperationId() != null && source.getObjectId() != null) {
            N2oObject object = (N2oObject)p.getOrThrow(source.getObjectId(), N2oObject.class);
            p.safeStreamOf((Object[])object.getOperations()).filter(operation -> source.getSubmitOperationId().equals(operation.getId())).findFirst().orElseThrow(() -> new N2oMetadataValidationException("\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u0435 \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b " + ValidationUtils.getIdOrEmptyString(source.getId()) + " \u0441\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0443\u044e \u0432 \u043e\u0431\u044a\u0435\u043a\u0442\u0435 " + source.getObjectId() + " \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044e " + source.getSubmitOperationId()));
        }
        PageScope pageScope = (PageScope)p.getScope(PageScope.class);
        this.checkRefreshWidgetDatasourceIds(source, pageScope, p);
        ValidatorDatasourceIdsScope datasourceIdsScope = (ValidatorDatasourceIdsScope)p.getScope(ValidatorDatasourceIdsScope.class);
        if (source.getDatasources() != null && datasourceIdsScope != null) {
            ValidatorDatasourceIdsScope actionDatasourceScope = new ValidatorDatasourceIdsScope(datasourceIdsScope);
            Arrays.stream(source.getDatasources()).filter(datasource -> datasource.getId() != null).forEach(datasource -> actionDatasourceScope.add(datasource.getId()));
            Arrays.stream(source.getDatasources()).filter(datasource -> datasource.getId() != null).forEach(datasource -> p.validate((Source)datasource, new Object[]{actionDatasourceScope}));
        }
        this.checkDatasourceInParam(source, p);
        PageActionValidator.checkEmptyToolbar(source);
    }

    private static void checkEmptyToolbar(N2oAbstractPageAction source) {
        N2oToolbar[] toolbars = source.getToolbars();
        if (Objects.nonNull(toolbars)) {
            for (N2oToolbar toolbar : toolbars) {
                if (toolbar.getItems() != null || toolbar.getGenerate() != null) continue;
                throw new N2oMetadataValidationException(String.format("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u044b \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b \u0438\u043b\u0438 \u0430\u0442\u0440\u0438\u0431\u0443\u0442 'generate' \u0432 \u0442\u0443\u043b\u0431\u0430\u0440\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b %s", ValidationUtils.getIdOrEmptyString(source.getPageId())));
            }
        }
    }

    private void checkRefreshWidgetDatasourceIds(N2oAbstractPageAction source, PageScope pageScope, SourceProcessor p) {
        if (source.getRefreshDatasourceIds() == null) {
            return;
        }
        String[] refreshDatasourceIds = source.getRefreshDatasourceIds();
        boolean isNotDatasource = false;
        ValidatorDatasourceIdsScope datasourceIdsScope = (ValidatorDatasourceIdsScope)p.getScope(ValidatorDatasourceIdsScope.class);
        if (refreshDatasourceIds.length == 1) {
            if (datasourceIdsScope != null && !datasourceIdsScope.contains(refreshDatasourceIds[0])) {
                isNotDatasource = true;
            }
            if (isNotDatasource && pageScope != null && !pageScope.getWidgetIds().contains(source.getRefreshWidgetId())) {
                throw new N2oMetadataValidationException(String.format("\u0410\u0442\u0440\u0438\u0431\u0443\u0442 'refresh-datasources'\\'refresh-widget-id' \u0441\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\\\u0432\u0438\u0434\u0436\u0435\u0442 %s", ValidationUtils.getIdOrEmptyString(refreshDatasourceIds[0])));
            }
        } else if (datasourceIdsScope != null) {
            for (String datasourceId : refreshDatasourceIds) {
                ValidationUtils.checkDatasourceExistence(datasourceId, p, String.format("\u0410\u0442\u0440\u0438\u0431\u0443\u0442 \"refresh-datasources\" \u0441\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445 %s", ValidationUtils.getIdOrEmptyString(datasourceId)));
            }
        }
    }

    private void checkDatasourceInParam(N2oAbstractPageAction action, SourceProcessor p) {
        N2oParam[] params = action.getParams();
        if (params != null) {
            Arrays.stream(params).forEach(param -> {
                if (param.getName() == null) {
                    throw new N2oMetadataValidationException(String.format("\u0412 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b %s \u043d\u0435 \u0437\u0430\u0434\u0430\u043d \u0430\u0442\u0440\u0438\u0431\u0443\u0442 'name'", ValidationUtils.getIdOrEmptyString(action.getPageId())));
                }
                if (param.getDatasourceId() != null) {
                    ValidationUtils.checkDatasourceExistence(param.getDatasourceId(), p, String.format("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 %s \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b \u0441\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445 %s", ValidationUtils.getIdOrEmptyString(param.getName()), ValidationUtils.getIdOrEmptyString(param.getDatasourceId())));
                }
            });
        }
    }

    public Class<? extends Source> getSourceClass() {
        return N2oAbstractPageAction.class;
    }
}

