/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.validation.standard.action;

import java.util.Arrays;
import java.util.Objects;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.action.N2oConfirmAction;
import net.n2oapp.framework.api.metadata.aware.SourceClassAware;
import net.n2oapp.framework.api.metadata.compile.SourceProcessor;
import net.n2oapp.framework.api.metadata.compile.enums.ColorEnum;
import net.n2oapp.framework.api.metadata.validate.SourceValidator;
import net.n2oapp.framework.api.metadata.validation.exception.N2oMetadataValidationException;
import net.n2oapp.framework.config.metadata.validation.standard.ValidationUtils;
import net.n2oapp.framework.config.util.StylesResolver;
import org.apache.commons.lang3.EnumUtils;
import org.springframework.stereotype.Component;

@Component
public class ConfirmActionValidator
implements SourceValidator<N2oConfirmAction>,
SourceClassAware {
    public Class<? extends Source> getSourceClass() {
        return N2oConfirmAction.class;
    }

    public void validate(N2oConfirmAction source, SourceProcessor p) {
        if (source.getConfirmButtons() != null && source.getConfirmButtons().length > 0) {
            if (source.getConfirmButtons().length == 1) {
                if (source.getConfirmButtons()[0] instanceof N2oConfirmAction.OkButton) {
                    throw new N2oMetadataValidationException("\u0412 \u0434\u0435\u0438\u0306\u0441\u0442\u0432\u0438\u0438 <confirm> \u0443\u043a\u0430\u0437\u0430\u043d\u0430 \u043a\u043d\u043e\u043f\u043a\u0430 <ok>, \u043d\u043e \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u0430 \u043a\u043d\u043e\u043f\u043a\u0430 <cancel>");
                }
                throw new N2oMetadataValidationException("\u0412 \u0434\u0435\u0438\u0306\u0441\u0442\u0432\u0438\u0438 <confirm> \u0443\u043a\u0430\u0437\u0430\u043d\u0430 \u043a\u043d\u043e\u043f\u043a\u0430 <cancel>, \u043d\u043e \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u0430 \u043a\u043d\u043e\u043f\u043a\u0430 <ok>");
            }
            if (source.getConfirmButtons().length == 2) {
                if (source.getConfirmButtons()[0] instanceof N2oConfirmAction.OkButton && source.getConfirmButtons()[1] instanceof N2oConfirmAction.OkButton) {
                    throw new N2oMetadataValidationException("\u0412 \u0434\u0435\u0438\u0306\u0441\u0442\u0432\u0438\u0438 <confirm> \u0443\u043a\u0430\u0437\u0430\u043d\u044b \u0434\u0432\u0435 \u043a\u043d\u043e\u043f\u043a\u0438 <ok>");
                }
                if (source.getConfirmButtons()[0] instanceof N2oConfirmAction.CancelButton && source.getConfirmButtons()[1] instanceof N2oConfirmAction.CancelButton) {
                    throw new N2oMetadataValidationException("\u0412 \u0434\u0435\u0438\u0306\u0441\u0442\u0432\u0438\u0438 <confirm> \u0443\u043a\u0430\u0437\u0430\u043d\u044b \u0434\u0432\u0435 \u043a\u043d\u043e\u043f\u043a\u0438 <cancel>");
                }
                Arrays.stream(source.getConfirmButtons()).forEach(b -> ConfirmActionValidator.checkColor(b.getColor()));
            } else {
                throw new N2oMetadataValidationException("\u0412 \u0434\u0435\u0438\u0306\u0441\u0442\u0432\u0438\u0438 <confirm> \u0443\u043a\u0430\u0437\u0430\u043d\u043e \u0431\u043e\u043b\u0435\u0435 \u0434\u0432\u0443\u0445 \u043a\u043d\u043e\u043f\u043e\u043a");
            }
        }
    }

    private static void checkColor(String color) {
        if (!(color == null || Objects.equals(color, "link") || color.startsWith("outline") || EnumUtils.isValidEnum(ColorEnum.class, (String)StylesResolver.camelToSnake(color)))) {
            throw new N2oMetadataValidationException(String.format("\u041e\u0434\u043d\u0430 \u0438\u0437 \u043a\u043d\u043e\u043f\u043e\u043a \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f <confirm> \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430 color=%s", ValidationUtils.getIdOrEmptyString(color)));
        }
    }
}

