/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.validation.standard.action;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.action.N2oAction;
import net.n2oapp.framework.api.metadata.action.ifelse.N2oConditionBranch;
import net.n2oapp.framework.api.metadata.aware.ActionsAware;
import net.n2oapp.framework.api.metadata.compile.SourceProcessor;
import net.n2oapp.framework.api.metadata.validation.TypedMetadataValidator;
import net.n2oapp.framework.api.metadata.validation.exception.N2oMetadataValidationException;
import net.n2oapp.framework.config.metadata.compile.ComponentScope;
import net.n2oapp.framework.config.metadata.compile.widget.MetaActions;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import net.n2oapp.framework.config.metadata.validation.standard.ValidationUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ActionsAwareValidator
extends TypedMetadataValidator<ActionsAware> {
    public Class<? extends Source> getSourceClass() {
        return ActionsAware.class;
    }

    public void validate(ActionsAware source, SourceProcessor p) {
        MetaActions metaActions = this.getMetaActions(p);
        N2oAction[] actions = source.getActions();
        String actionId = source.getActionId();
        if (actionId != null) {
            if (metaActions.isEmpty()) {
                throw new N2oMetadataValidationException(String.format("\u0414\u043b\u044f \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u0430 \u0441 action-id=\"%s\" \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f <actions>", actionId));
            }
            ValidationUtils.checkActionExistence(source.getActionId(), metaActions, String.format("\u041a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442 \u0441 action-id=\"%s\" \u0441\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0435\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0435 %s", actionId, source.getActionId()));
            if (ObjectUtils.isNotEmpty((Object)actions)) {
                throw new N2oMetadataValidationException(String.format("\u041a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442 \u0441 action-id=\"%s\" \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442 \u0441\u0441\u044b\u043b\u043a\u0443 action-id \u043e\u0434\u043d\u043e\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e", actionId));
            }
        }
        if (ObjectUtils.isNotEmpty((Object)actions)) {
            LinkedList ifElseBranches = Arrays.stream(actions).filter(N2oConditionBranch.class::isInstance).map(N2oConditionBranch.class::cast).collect(Collectors.toCollection(LinkedList::new));
            if (!ifElseBranches.isEmpty()) {
                ValidationUtils.validateIfElse(ifElseBranches, p);
            }
            Arrays.stream(actions).forEach(action -> p.validate((Source)action, new Object[]{metaActions, new ComponentScope(source, (ComponentScope)p.getScope(ComponentScope.class))}));
        }
    }

    private MetaActions getMetaActions(SourceProcessor p) {
        MetaActions metaActions;
        MetaActions pageActions = (MetaActions)p.getScope(MetaActions.class);
        WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
        MetaActions metaActions2 = metaActions = widgetScope == null || widgetScope.getActions() == null ? new MetaActions() : widgetScope.getActions();
        if (!CollectionUtils.isEmpty((Map)pageActions)) {
            metaActions.putAll(pageActions);
        }
        return metaActions;
    }
}

