/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.validation.standard;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.action.N2oAction;
import net.n2oapp.framework.api.metadata.action.N2oInvokeAction;
import net.n2oapp.framework.api.metadata.action.N2oOnFailAction;
import net.n2oapp.framework.api.metadata.action.ifelse.N2oConditionBranch;
import net.n2oapp.framework.api.metadata.action.ifelse.N2oElseBranchAction;
import net.n2oapp.framework.api.metadata.action.ifelse.N2oElseIfBranchAction;
import net.n2oapp.framework.api.metadata.action.ifelse.N2oIfBranchAction;
import net.n2oapp.framework.api.metadata.aware.IdAware;
import net.n2oapp.framework.api.metadata.aware.NamespaceUriAware;
import net.n2oapp.framework.api.metadata.compile.SourceProcessor;
import net.n2oapp.framework.api.metadata.compile.enums.ColorEnum;
import net.n2oapp.framework.api.metadata.global.dao.object.N2oObject;
import net.n2oapp.framework.api.metadata.global.dao.query.N2oQuery;
import net.n2oapp.framework.api.metadata.global.view.widget.dependency.N2oDependency;
import net.n2oapp.framework.api.metadata.validation.exception.N2oMetadataValidationException;
import net.n2oapp.framework.config.metadata.compile.datasource.ValidatorDataSourcesScope;
import net.n2oapp.framework.config.metadata.compile.widget.MetaActions;
import net.n2oapp.framework.config.metadata.validation.standard.ValidatorDatasourceIdsScope;
import net.n2oapp.framework.config.util.StylesResolver;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.EnumUtils;
import org.springframework.util.StringUtils;

public final class ValidationUtils {
    private static final SimpleDateFormat SIMPLE_DATETIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");

    private ValidationUtils() {
    }

    public static void checkIds(NamespaceUriAware[] items, SourceProcessor p) {
        if (items != null) {
            for (NamespaceUriAware item : items) {
                ValidationUtils.checkId(item, p);
            }
        }
    }

    public static void checkId(NamespaceUriAware item, SourceProcessor p) {
        if (item instanceof IdAware) {
            IdAware idAware = (IdAware)item;
            p.checkId(idAware, "\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043f\u043e\u043b\u044f '%s' \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043d\u044b\u043c \u0438\u043c\u0435\u043d\u0435\u043c");
        }
    }

    public static void checkDatasourceExistence(String dsId, SourceProcessor p, String msg) {
        ValidatorDatasourceIdsScope datasourceIdsScope = (ValidatorDatasourceIdsScope)p.getScope(ValidatorDatasourceIdsScope.class);
        ValidatorDataSourcesScope dataSourcesScope = (ValidatorDataSourcesScope)p.getScope(ValidatorDataSourcesScope.class);
        if (!(datasourceIdsScope != null && datasourceIdsScope.contains(dsId) || dataSourcesScope != null && dataSourcesScope.containsKey(dsId))) {
            throw new N2oMetadataValidationException(msg);
        }
    }

    public static void checkDatasourceExistenceInTag(String dsId, SourceProcessor p, @Nonnull String tag) {
        if (dsId != null) {
            ValidationUtils.checkDatasourceExistence(dsId, p, String.format("\u0422\u0435\u0433 %s \u0432 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0435 'datasource' \u0441\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445 %s", tag, dsId));
        }
    }

    public static void checkForExistsObject(String objectId, String messageFirstPart, SourceProcessor p) {
        p.checkForExists(objectId, N2oObject.class, String.format("%s \u0441\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u043e\u0431\u044a\u0435\u043a\u0442 %s", messageFirstPart, ValidationUtils.getIdOrEmptyString(objectId)));
    }

    public static N2oQuery checkQueryExists(String queryId, String messageFirstPart, SourceProcessor p) {
        if (queryId != null) {
            p.checkForExists(queryId, N2oQuery.class, String.format("%s \u0441\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0443\u044e \u0432\u044b\u0431\u043e\u0440\u043a\u0443 %s", messageFirstPart, ValidationUtils.getIdOrEmptyString(queryId)));
            return (N2oQuery)p.getOrThrow(queryId, N2oQuery.class);
        }
        return null;
    }

    public static void checkActionExistence(@Nonnull String actionId, @Nonnull MetaActions actionsScope, @Nonnull String msg) {
        if (!actionsScope.containsKey(actionId)) {
            throw new N2oMetadataValidationException(msg);
        }
    }

    public static void validateIfElse(Queue<N2oConditionBranch> branches, SourceProcessor p) {
        if (!(branches.element() instanceof N2oIfBranchAction)) {
            throw new N2oMetadataValidationException("\u0423\u0441\u043b\u043e\u0432\u043d\u044b\u0439 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440 if-else \u043d\u0430\u0447\u0438\u043d\u0430\u0435\u0442\u0441\u044f \u043d\u0435 \u0441 \u0442\u0435\u0433\u0430 <if>");
        }
        LinkedList<N2oConditionBranch> operator = ValidationUtils.constructOperator(branches);
        ValidationUtils.checkDatasourceExistenceInTag(((N2oIfBranchAction)operator.getFirst()).getDatasourceId(), p, "<if>");
        Optional<N2oElseIfBranchAction> elseIfBranch = ValidationUtils.findFirstByInstance(operator, N2oElseIfBranchAction.class);
        Optional<N2oElseBranchAction> elseBranch = ValidationUtils.findFirstByInstance(operator, N2oElseBranchAction.class);
        if (elseIfBranch.isPresent() && elseBranch.isPresent() && operator.indexOf(elseIfBranch.get()) > operator.indexOf(elseBranch.get())) {
            throw new N2oMetadataValidationException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043f\u043e\u0440\u044f\u0434\u043e\u043a \u0442\u0435\u0433\u043e\u0432 <else-if> \u0438 <else> \u0432 \u0443\u0441\u043b\u043e\u0432\u043d\u043e\u043c \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0435 if-else");
        }
        for (N2oConditionBranch operatorBranch : operator) {
            if (operatorBranch instanceof N2oIfBranchAction) {
                ValidationUtils.checkTest(operatorBranch, p, "<if>");
            } else if (operatorBranch instanceof N2oElseIfBranchAction) {
                ValidationUtils.checkTest(operatorBranch, p, "<else-if>");
            }
            p.validate((Source)operatorBranch, new Object[0]);
        }
        if (!branches.isEmpty()) {
            ValidationUtils.validateIfElse(branches, p);
        }
    }

    public static String getIdOrEmptyString(String metadataId) {
        return metadataId != null ? StringUtils.quote((String)metadataId) : "";
    }

    public static String getSpaceWithIdOrEmptyString(String metadataId) {
        return metadataId != null ? " " + StringUtils.quote((String)metadataId) : "";
    }

    public static void checkEmptyDependency(N2oDependency dependency, String message) {
        if (!StringUtils.hasText((String)dependency.getValue())) {
            throw new N2oMetadataValidationException(message);
        }
    }

    public static void checkInteger(String text, String message) {
        try {
            Integer.parseInt(text);
        }
        catch (NumberFormatException nfe) {
            throw new N2oMetadataValidationException(message);
        }
    }

    public static void checkShort(String text, String message) {
        try {
            Short.parseShort(text);
        }
        catch (NumberFormatException nfe) {
            throw new N2oMetadataValidationException(message);
        }
    }

    public static void checkByte(String text, String message) {
        try {
            Byte.parseByte(text);
        }
        catch (NumberFormatException nfe) {
            throw new N2oMetadataValidationException(message);
        }
    }

    public static void checkDouble(String text, String message) {
        try {
            Double.parseDouble(text);
        }
        catch (NumberFormatException nfe) {
            throw new N2oMetadataValidationException(message);
        }
    }

    public static void checkDate(String date, String message) {
        if (!ValidationUtils.isValidDateByFormat(date, SIMPLE_DATETIME_FORMAT) && !ValidationUtils.isValidDateByFormat(date, SIMPLE_DATE_FORMAT)) {
            throw new N2oMetadataValidationException(message);
        }
    }

    public static void checkOnFailActionNotExist(N2oAction[] actions, String componentName) {
        if (actions != null) {
            if (Stream.of(actions).anyMatch(N2oOnFailAction.class::isInstance)) {
                throw new N2oMetadataValidationException(String.format("\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u0435 <on-fail> \u043d\u0435\u043b\u044c\u0437\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0432 %s", componentName));
            }
        }
    }

    public static void checkOnFailAction(N2oAction[] actions) {
        if (actions == null || actions.length == 0) {
            return;
        }
        List<N2oAction> onFailActions = Stream.of(actions).filter(N2oOnFailAction.class::isInstance).toList();
        if (CollectionUtils.isNotEmpty(onFailActions)) {
            if (onFailActions.size() > 1) {
                throw new N2oMetadataValidationException("\u041d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u0435\u0435 \u043e\u0434\u043d\u043e\u0433\u043e \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430 <on-fail>");
            }
            if (onFailActions.size() == 1) {
                if (!(actions[actions.length - 1] instanceof N2oOnFailAction)) {
                    throw new N2oMetadataValidationException("\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u0435 <on-fail> \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u043c \u0432 \u0441\u043f\u0438\u0441\u043a\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0439");
                }
                if (Stream.of(actions).noneMatch(N2oInvokeAction.class::isInstance)) {
                    throw new N2oMetadataValidationException("\u0417\u0430\u0434\u0430\u043d\u043e \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0435 <on-fail> \u043f\u0440\u0438 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0435\u043c \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0438 <invoke>");
                }
            }
        }
    }

    public static boolean isInvalidColor(String color) {
        return color != null && !net.n2oapp.framework.api.StringUtils.isLink((Object)color) && !EnumUtils.isValidEnum(ColorEnum.class, (String)StylesResolver.camelToSnake(color));
    }

    private static boolean isValidDateByFormat(String date, SimpleDateFormat dateFormat) {
        try {
            dateFormat.parseObject(date);
        }
        catch (ParseException ex) {
            return false;
        }
        return true;
    }

    private static void checkTest(N2oConditionBranch branch, SourceProcessor p, @Nonnull String tag) {
        p.checkNotNull((Object)branch.getTest(), String.format("\u0412 \u0442\u0435\u0433\u0435 %s \u0443\u0441\u043b\u043e\u0432\u043d\u043e\u0433\u043e \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0435 if-else \u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e \u0443\u0441\u043b\u043e\u0432\u0438\u0435 'test'", tag));
    }

    private static <T> Optional<T> findFirstByInstance(List<? super T> list, Class<T> clazz) {
        if (list == null) {
            return Optional.empty();
        }
        return list.stream().filter(clazz::isInstance).map(clazz::cast).findFirst();
    }

    private static LinkedList<N2oConditionBranch> constructOperator(Queue<N2oConditionBranch> branches) {
        LinkedList<N2oConditionBranch> ifElseOperator = new LinkedList<N2oConditionBranch>();
        ifElseOperator.add(branches.poll());
        while (!branches.isEmpty() && !(branches.element() instanceof N2oIfBranchAction)) {
            ifElseOperator.add(branches.poll());
        }
        return ifElseOperator;
    }
}

