/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.validation;

import java.util.ArrayList;
import java.util.List;
import net.n2oapp.framework.api.data.validation.InvocationValidation;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.global.dao.object.AbstractParameter;
import net.n2oapp.framework.api.metadata.global.dao.object.field.ObjectReferenceField;
import net.n2oapp.framework.api.metadata.global.dao.object.field.ObjectSimpleField;
import net.n2oapp.framework.api.metadata.global.dao.validation.N2oInvocationValidation;
import net.n2oapp.framework.config.metadata.compile.validation.BaseValidationCompiler;

public abstract class InvocationValidationCompiler<D extends InvocationValidation, S extends N2oInvocationValidation>
extends BaseValidationCompiler<D, S> {
    protected void compileInvocationValidation(D compiled, S source, CompileProcessor p) {
        this.compileValidation(compiled, source, p);
        compiled.setId(source.getId());
        compiled.setInvocation(source.getN2oInvocation());
        compiled.setInParametersList(this.getParams(source.getInFields()));
        List<AbstractParameter> outParams = this.getParams((AbstractParameter[])source.getOutFields());
        ObjectSimpleField resultParam = new ObjectSimpleField();
        resultParam.setId("validation");
        resultParam.setMapping(source.getResult());
        outParams.add((AbstractParameter)resultParam);
        compiled.setOutParametersList(outParams);
    }

    private List<AbstractParameter> getParams(AbstractParameter[] parameters) {
        ArrayList<AbstractParameter> params = new ArrayList<AbstractParameter>();
        if (parameters != null) {
            for (AbstractParameter parameter : parameters) {
                ObjectReferenceField objectReferenceField;
                if (parameter instanceof ObjectSimpleField) {
                    ObjectSimpleField objectSimpleField = (ObjectSimpleField)parameter;
                    objectReferenceField = new ObjectSimpleField(objectSimpleField);
                } else {
                    objectReferenceField = new ObjectReferenceField((ObjectReferenceField)parameter);
                }
                params.add((AbstractParameter)objectReferenceField);
            }
        }
        return params;
    }
}

