/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.toolbar;

import java.util.Collections;
import java.util.List;
import net.n2oapp.framework.api.criteria.filters.FilterTypeEnum;
import net.n2oapp.framework.api.metadata.N2oAbstractDatasource;
import net.n2oapp.framework.api.metadata.ReduxModelEnum;
import net.n2oapp.framework.api.metadata.action.N2oAbstractAction;
import net.n2oapp.framework.api.metadata.action.N2oAction;
import net.n2oapp.framework.api.metadata.action.N2oConfirmAction;
import net.n2oapp.framework.api.metadata.action.N2oInvokeAction;
import net.n2oapp.framework.api.metadata.action.N2oShowModal;
import net.n2oapp.framework.api.metadata.compile.ButtonGenerator;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.global.dao.N2oPathParam;
import net.n2oapp.framework.api.metadata.global.dao.N2oPreFilter;
import net.n2oapp.framework.api.metadata.global.view.page.DefaultValuesModeEnum;
import net.n2oapp.framework.api.metadata.global.view.page.datasource.N2oStandardDatasource;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oButton;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.ToolbarItem;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.config.metadata.compile.action.DefaultActionsEnum;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import net.n2oapp.framework.config.register.route.RouteUtil;

public abstract class AbstractButtonGenerator
implements ButtonGenerator {
    protected List<ToolbarItem> build(DefaultActionsEnum action, CompileProcessor p) {
        N2oButton button = new N2oButton();
        button.setId(action.getId());
        button.setLabel(p.getMessage(action.getLabel(), new Object[0]));
        button.setIcon(action.getIcon());
        if (action.isContext()) {
            button.setModel(ReduxModelEnum.RESOLVE);
        } else {
            button.setModel(ReduxModelEnum.FILTER);
        }
        switch (action) {
            case DELETE: {
                N2oConfirmAction confirmAction = new N2oConfirmAction();
                N2oInvokeAction invokeAction = new N2oInvokeAction();
                invokeAction.setOperationId(action.getId());
                WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
                String widgetId = widgetScope != null && widgetScope.getWidgetId() != null ? widgetScope.getWidgetId() : "";
                invokeAction.setRoute(RouteUtil.normalize("/" + widgetId + "/delete"));
                button.setActions((N2oAction[])new N2oAbstractAction[]{confirmAction, invokeAction});
                break;
            }
            case CREATE: {
                N2oShowModal modal = new N2oShowModal();
                CompiledObject object = (CompiledObject)p.getScope(CompiledObject.class);
                modal.setPageId(object.getId());
                modal.setObjectId(object.getId());
                modal.setPageName(p.getMessage(action.getPageName(), new Object[]{object.getName()}));
                modal.setSubmitOperationId(action.getId());
                N2oStandardDatasource datasource = new N2oStandardDatasource();
                datasource.setDefaultValuesMode(DefaultValuesModeEnum.DEFAULTS);
                modal.setDatasources((N2oAbstractDatasource[])new N2oStandardDatasource[]{datasource});
                modal.setCloseAfterSubmit(Boolean.valueOf(true));
                WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
                String widgetId = widgetScope != null && widgetScope.getWidgetId() != null ? widgetScope.getWidgetId() : "";
                modal.setRoute(RouteUtil.normalize("/" + widgetId + "/create"));
                button.setActions((N2oAction[])new N2oShowModal[]{modal});
                break;
            }
            case UPDATE: {
                N2oShowModal modal = new N2oShowModal();
                CompiledObject object = (CompiledObject)p.getScope(CompiledObject.class);
                modal.setPageId(object.getId());
                modal.setObjectId(object.getId());
                modal.setPageName(p.getMessage(action.getPageName(), new Object[]{object.getName()}));
                WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
                String widgetId = widgetScope != null && widgetScope.getWidgetId() != null ? widgetScope.getWidgetId() : "";
                String paramName = widgetId + "_id";
                modal.setRoute(RouteUtil.normalize("/" + widgetId + "/:" + paramName + "/update"));
                N2oPathParam pathParam = new N2oPathParam();
                pathParam.setName(paramName);
                pathParam.setValue(Placeholders.ref((String)"id"));
                modal.addPathParams(new N2oPathParam[]{pathParam});
                N2oStandardDatasource datasource = new N2oStandardDatasource();
                datasource.setDefaultValuesMode(DefaultValuesModeEnum.QUERY);
                N2oPreFilter masterDetailFilter = new N2oPreFilter();
                masterDetailFilter.setType(FilterTypeEnum.EQ);
                masterDetailFilter.setFieldId("id");
                masterDetailFilter.setParam(paramName);
                datasource.setFilters(new N2oPreFilter[]{masterDetailFilter});
                modal.setDatasources((N2oAbstractDatasource[])new N2oStandardDatasource[]{datasource});
                modal.setSubmitOperationId(action.getId());
                modal.setCloseAfterSubmit(Boolean.valueOf(true));
                button.setActions((N2oAction[])new N2oShowModal[]{modal});
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return Collections.singletonList(button);
    }
}

