/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.region;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.global.view.region.N2oScrollspyRegion;
import net.n2oapp.framework.api.metadata.global.view.region.RoutableRegion;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.region.scrollspy.GroupScrollspyElement;
import net.n2oapp.framework.api.metadata.meta.region.scrollspy.MenuScrollspyElement;
import net.n2oapp.framework.api.metadata.meta.region.scrollspy.ScrollspyElement;
import net.n2oapp.framework.api.metadata.meta.region.scrollspy.ScrollspyRegion;
import net.n2oapp.framework.api.metadata.meta.region.scrollspy.SingleScrollspyElement;
import net.n2oapp.framework.config.metadata.compile.context.PageContext;
import net.n2oapp.framework.config.metadata.compile.region.BaseRegionCompiler;
import org.springframework.stereotype.Component;

@Component
public class ScrollspyRegionCompiler
extends BaseRegionCompiler<ScrollspyRegion, N2oScrollspyRegion> {
    private static final String PLACEMENT_PROPERTY = "n2o.api.region.scrollspy.placement";
    private static final String HEADLINES_PROPERTY = "n2o.api.region.scrollspy.headlines";
    private static final String ROUTABLE_PROPERTY = "n2o.api.region.scrollspy.routable";
    private static final String GROUP_HEADLINE_PROPERTY = "n2o.api.region.scrollspy.group.headline";

    public Class<? extends Source> getSourceClass() {
        return N2oScrollspyRegion.class;
    }

    @Override
    protected String createId(CompileProcessor p) {
        return this.createId("scrollspy", p);
    }

    @Override
    protected String getSrcProperty() {
        return "n2o.api.region.scrollspy.src";
    }

    public ScrollspyRegion compile(N2oScrollspyRegion source, PageContext context, CompileProcessor p) {
        ScrollspyRegion region = new ScrollspyRegion();
        this.build(region, source, p);
        region.setTitle(source.getTitle());
        region.setPlacement((String)CompileUtil.castDefault((Object)source.getPlacement(), (Supplier[])new Supplier[]{() -> (String)p.resolve(Placeholders.property((String)PLACEMENT_PROPERTY), String.class)}));
        region.setHeadlines((Boolean)CompileUtil.castDefault((Object)source.getHeadlines(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)HEADLINES_PROPERTY), Boolean.class)}));
        region.setMaxHeight(StringUtils.prepareSizeAttribute((String)source.getMaxHeight()));
        region.setMenu(this.initMenu(source.getMenu(), context, p));
        region.setActive(source.getActive());
        region.setActiveParam(source.getActiveParam());
        this.compileRoute((RoutableRegion)source, region.getId(), ROUTABLE_PROPERTY, p);
        return region;
    }

    private List<ScrollspyElement> initMenu(N2oScrollspyRegion.AbstractMenuItem[] items, PageContext context, CompileProcessor p) {
        if (Objects.isNull(items) || items.length == 0) {
            return null;
        }
        ArrayList<ScrollspyElement> elements = new ArrayList<ScrollspyElement>();
        for (N2oScrollspyRegion.AbstractMenuItem item : items) {
            if (item instanceof N2oScrollspyRegion.MenuItem) {
                elements.add((ScrollspyElement)this.initSingleElement(item, context, p));
                continue;
            }
            if (item instanceof N2oScrollspyRegion.SubMenuItem) {
                elements.add((ScrollspyElement)this.initSubElement(item, context, p));
                continue;
            }
            if (!(item instanceof N2oScrollspyRegion.GroupItem)) continue;
            elements.add((ScrollspyElement)this.initGroupElement(item, context, p));
        }
        return elements;
    }

    private SingleScrollspyElement initSingleElement(N2oScrollspyRegion.AbstractMenuItem item, PageContext context, CompileProcessor p) {
        SingleScrollspyElement element = new SingleScrollspyElement();
        this.initElement((ScrollspyElement)element, item, p);
        element.setContent(this.initContent(((N2oScrollspyRegion.MenuItem)item).getContent(), context, p, (Source)item));
        return element;
    }

    private MenuScrollspyElement initSubElement(N2oScrollspyRegion.AbstractMenuItem item, PageContext context, CompileProcessor p) {
        MenuScrollspyElement element = new MenuScrollspyElement();
        this.initElement((ScrollspyElement)element, item, p);
        element.setMenu(this.initMenu(((N2oScrollspyRegion.SubMenuItem)item).getSubMenu(), context, p));
        return element;
    }

    private GroupScrollspyElement initGroupElement(N2oScrollspyRegion.AbstractMenuItem item, PageContext context, CompileProcessor p) {
        GroupScrollspyElement element = new GroupScrollspyElement();
        this.initElement((ScrollspyElement)element, item, p);
        element.setGroup(this.initMenu(((N2oScrollspyRegion.GroupItem)item).getGroup(), context, p));
        element.setHeadline((Boolean)CompileUtil.castDefault((Object)((N2oScrollspyRegion.GroupItem)item).getHeadline(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)GROUP_HEADLINE_PROPERTY), Boolean.class)}));
        return element;
    }

    private void initElement(ScrollspyElement element, N2oScrollspyRegion.AbstractMenuItem item, CompileProcessor p) {
        element.setId((String)CompileUtil.castDefault((Object)item.getId(), (Object)this.createId("element_scrollspy", p), (Object[])new String[0]));
        element.setTitle(item.getTitle());
    }
}

