/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.n2oapp.framework.api.DynamicUtil;
import net.n2oapp.framework.api.criteria.filters.FilterTypeEnum;
import net.n2oapp.framework.api.data.DomainProcessor;
import net.n2oapp.framework.api.data.validation.MandatoryValidation;
import net.n2oapp.framework.api.exception.SeverityTypeEnum;
import net.n2oapp.framework.api.metadata.aware.ExtensionAttributesAware;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.dataprovider.N2oRestDataProvider;
import net.n2oapp.framework.api.metadata.global.dao.invocation.N2oInvocation;
import net.n2oapp.framework.api.metadata.global.dao.query.AbstractField;
import net.n2oapp.framework.api.metadata.global.dao.query.N2oQuery;
import net.n2oapp.framework.api.metadata.global.dao.query.field.QueryReferenceField;
import net.n2oapp.framework.api.metadata.global.dao.query.field.QuerySimpleField;
import net.n2oapp.framework.api.metadata.global.dao.validation.N2oValidation;
import net.n2oapp.framework.api.metadata.global.view.widget.table.N2oSwitch;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.api.metadata.local.CompiledQuery;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.Filter;
import net.n2oapp.framework.config.metadata.compile.BaseSourceCompiler;
import net.n2oapp.framework.config.metadata.compile.N2oCompileProcessor;
import net.n2oapp.framework.config.metadata.compile.context.ObjectContext;
import net.n2oapp.framework.config.metadata.compile.context.QueryContext;
import net.n2oapp.framework.config.register.route.RouteUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class N2oQueryCompiler
implements BaseSourceCompiler<CompiledQuery, N2oQuery, QueryContext> {
    private static final String IS_SELECTED = "n2o.api.query.field.is_selected";
    private static final String IS_SORTED = "n2o.api.query.field.is_sorted";
    private static final String FILTERS_SEPARATOR = "n2o.config.rest.filters_separator";
    private static final String SELECT_SEPARATOR = "n2o.config.rest.select_separator";
    private static final String JOIN_SEPARATOR = "n2o.config.rest.join_separator";
    private static final String SORTING_SEPARATOR = "n2o.config.rest.sorting_separator";

    public Class<N2oQuery> getSourceClass() {
        return N2oQuery.class;
    }

    public CompiledQuery compile(N2oQuery source, QueryContext context, CompileProcessor p) {
        String route;
        source.initAbsoluteIds();
        CompiledQuery query = new CompiledQuery();
        String queryId = context.getSourceId((N2oCompileProcessor)p);
        query.setId(queryId);
        if (source.getObjectId() != null) {
            query.setObject((CompiledObject)p.getCompiled((CompileContext)new ObjectContext(source.getObjectId())));
        }
        query.setRoute(DynamicUtil.isDynamic((String)(route = RouteUtil.normalize((String)CompileUtil.castDefault((Object)source.getRoute(), (Object)queryId, (Object[])new String[0])))) ? route.replaceAll("[?=&]", "_") : route);
        query.setLists(this.initSeparators(source.getLists(), p));
        query.setUniques(this.initSeparators(source.getUniques(), p));
        query.setCounts(this.initSeparators(source.getCounts(), p));
        if (!CollectionUtils.isEmpty(context.getValidations())) {
            query.setValidations(context.getValidations());
        }
        List<AbstractField> fields = source.getFields() != null ? Arrays.asList(source.getFields()) : List.of();
        this.initDefaultFilters(source.getFilters());
        this.initDefaultFields(fields, (Boolean)p.resolve(Placeholders.property((String)IS_SELECTED), Boolean.class), (Boolean)p.resolve(Placeholders.property((String)IS_SORTED), Boolean.class), p);
        this.compilePreFilters(source, p, context.getFilters());
        query.setDisplayFields(Collections.unmodifiableList(N2oQueryCompiler.initDisplayFields(fields)));
        List simpleFields = source.getSimpleFields();
        query.setSortingFields(Collections.unmodifiableList(N2oQueryCompiler.initSortingFields(simpleFields)));
        query.setFieldsMap(Collections.unmodifiableMap(N2oQueryCompiler.initFieldsMap(fields, query.getId())));
        query.setSimpleFieldsMap(Collections.unmodifiableMap(N2oQueryCompiler.initSimpleFieldsMap(simpleFields)));
        query.setFiltersMap(Collections.unmodifiableMap(this.initFiltersMap(source, query, p)));
        query.setInvertFiltersMap(Collections.unmodifiableMap(this.initInvertFiltersMap(source, query.getFieldsMap())));
        query.setFilterFieldsMap(Collections.unmodifiableMap(this.initFilterFieldsMap(query.getFiltersMap())));
        query.setParamToFilterIdMap(Collections.unmodifiableMap(this.initParamToFilterIdMap(query.getFilterFieldsMap())));
        query.setFilterIdToParamMap(Collections.unmodifiableMap(this.initFilterIdToParamMap(query.getParamToFilterIdMap())));
        query.setSubModelQueries(context.getSubModelQueries());
        this.initExpressions(query);
        query.setProperties(p.mapAttributes((ExtensionAttributesAware)source));
        query.setCopiedFields(context.getCopiedFields());
        return query;
    }

    private static List<AbstractField> initDisplayFields(List<AbstractField> fields) {
        return fields.stream().filter(AbstractField::getIsSelected).toList();
    }

    private static Map<String, AbstractField> initFieldsMap(List<AbstractField> fields, String id) {
        HashMap<String, AbstractField> result = new HashMap<String, AbstractField>();
        for (AbstractField field : fields) {
            result.put(field.getAbsoluteId(), field);
            if (!(field instanceof QueryReferenceField)) continue;
            QueryReferenceField referenceField = (QueryReferenceField)field;
            result.putAll(N2oQueryCompiler.initFieldsMap(Arrays.asList(referenceField.getFields()), id));
        }
        return result;
    }

    private void compilePreFilters(N2oQuery source, CompileProcessor p, List<Filter> preFilters) {
        if (preFilters == null || source.getFilters() == null) {
            return;
        }
        for (Filter preFilter : preFilters) {
            for (N2oQuery.Filter filter : source.getFilters()) {
                if (!filter.getFilterId().equals(preFilter.getFilterId())) continue;
                filter.setParam((String)CompileUtil.castDefault((Object)preFilter.getParam(), (Object)filter.getParam(), (Object[])new String[0]));
                if (preFilter.getLink() == null || preFilter.getLink().isLink()) continue;
                filter.setCompiledDefaultValue(CompileUtil.castDefault((Object)preFilter.getLink().getValue(), (Supplier[])new Supplier[]{() -> p.resolve(filter.getDefaultValue(), filter.getDomain())}));
            }
        }
    }

    private Map<String, Map.Entry<String, FilterTypeEnum>> initInvertFiltersMap(N2oQuery source, Map<String, AbstractField> fieldsMap) {
        HashMap<String, Map.Entry<String, FilterTypeEnum>> invertFiltersMap = new HashMap<String, Map.Entry<String, FilterTypeEnum>>();
        fieldsMap.keySet().stream().filter(arg_0 -> ((N2oQuery)source).isSearchAvailable(arg_0)).map(fieldsMap::get).forEach(queryField -> {
            for (N2oQuery.Filter f : source.getFiltersList(queryField.getAbsoluteId())) {
                invertFiltersMap.put(f.getFilterId(), (Map.Entry<String, FilterTypeEnum>)new CompiledQuery.FilterEntry(queryField.getAbsoluteId(), f.getType()));
            }
        });
        return invertFiltersMap;
    }

    private Map<String, String> initParamToFilterIdMap(Map<String, N2oQuery.Filter> filterIdsMap) {
        HashMap<String, String> filterParams = new HashMap<String, String>();
        for (N2oQuery.Filter filter : filterIdsMap.values()) {
            String param = (String)CompileUtil.castDefault((Object)filter.getParam(), (Supplier[])new Supplier[]{() -> RouteUtil.normalizeParam(filter.getFilterId())});
            filterParams.put(param, filter.getFilterId());
        }
        return filterParams;
    }

    private Map<String, String> initFilterIdToParamMap(Map<String, String> paramToFilterMap) {
        HashMap<String, String> filterParams = new HashMap<String, String>();
        for (Map.Entry<String, String> paramEntry : paramToFilterMap.entrySet()) {
            filterParams.put(paramEntry.getValue(), paramEntry.getKey());
        }
        return filterParams;
    }

    private Map<String, N2oQuery.Filter> initFilterFieldsMap(Map<String, Map<FilterTypeEnum, N2oQuery.Filter>> filtersMap) {
        HashMap<String, N2oQuery.Filter> result = new HashMap<String, N2oQuery.Filter>();
        for (Map<FilterTypeEnum, N2oQuery.Filter> filterMap : filtersMap.values()) {
            for (N2oQuery.Filter filter : filterMap.values()) {
                result.put(filter.getFilterId(), filter);
            }
        }
        return result;
    }

    private void initExpressions(CompiledQuery query) {
        query.setSelectExpressions(query.getDisplayFields().stream().map(AbstractField::getSelectExpression).filter(Objects::nonNull).toList());
    }

    private N2oQuery.Selection[] initSeparators(N2oQuery.Selection[] selections, CompileProcessor p) {
        if (selections == null) {
            return null;
        }
        for (N2oQuery.Selection selection : selections) {
            N2oInvocation n2oInvocation = selection.getInvocation();
            if (!(n2oInvocation instanceof N2oRestDataProvider)) continue;
            N2oRestDataProvider restDataProvider = (N2oRestDataProvider)n2oInvocation;
            restDataProvider.setFiltersSeparator((String)CompileUtil.castDefault((Object)restDataProvider.getFiltersSeparator(), (Supplier[])new Supplier[]{() -> (String)p.resolve(Placeholders.property((String)FILTERS_SEPARATOR), String.class)}));
            restDataProvider.setSelectSeparator((String)CompileUtil.castDefault((Object)restDataProvider.getSelectSeparator(), (Supplier[])new Supplier[]{() -> (String)p.resolve(Placeholders.property((String)SELECT_SEPARATOR), String.class)}));
            restDataProvider.setJoinSeparator((String)CompileUtil.castDefault((Object)restDataProvider.getJoinSeparator(), (Supplier[])new Supplier[]{() -> (String)p.resolve(Placeholders.property((String)JOIN_SEPARATOR), String.class)}));
            restDataProvider.setSortingSeparator((String)CompileUtil.castDefault((Object)restDataProvider.getSortingSeparator(), (Supplier[])new Supplier[]{() -> (String)p.resolve(Placeholders.property((String)SORTING_SEPARATOR), String.class)}));
        }
        return selections;
    }

    private Map<String, Map<FilterTypeEnum, N2oQuery.Filter>> initFiltersMap(N2oQuery source, CompiledQuery query, CompileProcessor p) {
        HashMap<String, Map<FilterTypeEnum, N2oQuery.Filter>> result = new HashMap<String, Map<FilterTypeEnum, N2oQuery.Filter>>();
        query.getFieldsMap().keySet().stream().filter(arg_0 -> ((N2oQuery)source).isSearchAvailable(arg_0)).forEach(key -> {
            AbstractField queryField = (AbstractField)query.getFieldsMap().get(key);
            EnumMap<FilterTypeEnum, N2oQuery.Filter> filters = new EnumMap<FilterTypeEnum, N2oQuery.Filter>(FilterTypeEnum.class);
            for (N2oQuery.Filter f : source.getFiltersList(queryField.getAbsoluteId())) {
                if (f.getDomain() == null && queryField instanceof QuerySimpleField) {
                    QuerySimpleField simpleField = (QuerySimpleField)queryField;
                    f.setDomain(DomainProcessor.getDomain((String)simpleField.getDomain(), (FilterTypeEnum)f.getType()));
                }
                if (f.getCompiledDefaultValue() == null && f.getDefaultValue() != null) {
                    f.setCompiledDefaultValue(p.resolve(f.getDefaultValue(), f.getDomain()));
                }
                filters.put(f.getType(), f);
                this.initValidation(query, p, f);
            }
            result.put(queryField.getAbsoluteId(), filters);
        });
        return result;
    }

    private void initValidation(CompiledQuery query, CompileProcessor p, N2oQuery.Filter f) {
        if (f.getRequired() != null && f.getRequired().booleanValue()) {
            MandatoryValidation mandatory = new MandatoryValidation(f.getFilterId(), p.getMessage("n2o.required.filter", new Object[0]), f.getFilterId());
            mandatory.setMoment(N2oValidation.ServerMomentEnum.BEFORE_QUERY);
            mandatory.setSeverity(SeverityTypeEnum.DANGER);
            if (query.getValidations() == null) {
                query.setValidations(new ArrayList());
            }
            query.getValidations().add(mandatory);
        }
    }

    private void initDefaultFilters(N2oQuery.Filter[] filters) {
        if (filters == null) {
            return;
        }
        for (N2oQuery.Filter filter : filters) {
            filter.setFilterId((String)CompileUtil.castDefault((Object)filter.getFilterId(), (Supplier[])new Supplier[]{() -> RouteUtil.normalizeParam(filter.getFieldId()) + "_" + String.valueOf(filter.getType())}));
            filter.setParam((String)CompileUtil.castDefault((Object)filter.getParam(), (Supplier[])new Supplier[]{() -> RouteUtil.normalizeParam(filter.getFilterId())}));
            if (filter.getText() != null) {
                filter.setText(filter.getText().trim());
            }
            if (filter.getMapping() != null) continue;
            filter.setMapping(Placeholders.spel((String)filter.getFilterId()));
        }
    }

    private void initDefaultFields(List<AbstractField> fields, Boolean defaultSelected, Boolean defaultSorted, CompileProcessor p) {
        for (AbstractField field : fields) {
            field.setIsSelected((Boolean)CompileUtil.castDefault((Object)field.getIsSelected(), (Object)defaultSelected, (Object[])new Boolean[0]));
            if (field.getIsSelected().booleanValue()) {
                field.setMapping((String)CompileUtil.castDefault((Object)field.getMapping(), (Supplier[])new Supplier[]{() -> Placeholders.spel((String)field.getId())}));
            }
            if (field instanceof QueryReferenceField) {
                QueryReferenceField referenceField = (QueryReferenceField)field;
                field.setMapping((String)CompileUtil.castDefault((Object)field.getMapping(), (Supplier[])new Supplier[]{() -> Placeholders.spel((String)field.getId())}));
                this.initDefaultFields(Arrays.asList(referenceField.getFields()), defaultSelected, defaultSorted, p);
                continue;
            }
            this.initDefaultSimpleField((QuerySimpleField)field, defaultSorted, p);
        }
    }

    private void initDefaultSimpleField(QuerySimpleField field, Boolean defaultSorted, CompileProcessor p) {
        field.setName((String)CompileUtil.castDefault((Object)field.getName(), (Object)field.getId(), (Object[])new String[0]));
        field.setIsSorted((Boolean)CompileUtil.castDefault((Object)field.getIsSorted(), (Object)(!StringUtils.isBlank((CharSequence)field.getSortingExpression()) ? 1 : 0), (Object[])new Boolean[]{defaultSorted}));
        if (field.getIsSorted().booleanValue()) {
            field.setSortingMapping((String)CompileUtil.castDefault((Object)field.getSortingMapping(), (Supplier[])new Supplier[]{() -> Placeholders.spel((String)(field.getId() + "Direction"))}));
        }
        this.compileSwitch(field, p);
    }

    private void compileSwitch(QuerySimpleField field, CompileProcessor p) {
        N2oSwitch n2oSwitch = field.getN2oSwitch();
        if (n2oSwitch == null) {
            return;
        }
        field.getN2oSwitch().setValueFieldId(field.getId());
        HashMap<Object, String> resolvedCases = new HashMap<Object, String>();
        if (!MapUtils.isEmpty((Map)n2oSwitch.getCases())) {
            for (String key : n2oSwitch.getCases().keySet()) {
                resolvedCases.put(p.resolve(key), (String)n2oSwitch.getCases().get(key));
            }
        }
        n2oSwitch.setResolvedCases(resolvedCases);
    }

    private static List<QuerySimpleField> initSortingFields(List<QuerySimpleField> fields) {
        ArrayList<QuerySimpleField> result = new ArrayList<QuerySimpleField>();
        for (QuerySimpleField field : fields) {
            if (!field.getIsSorted().booleanValue()) continue;
            result.add(field);
        }
        return result;
    }

    private static Map<String, QuerySimpleField> initSimpleFieldsMap(List<QuerySimpleField> fields) {
        HashMap<String, QuerySimpleField> result = new HashMap<String, QuerySimpleField>();
        for (QuerySimpleField field : fields) {
            result.put(field.getAbsoluteId(), field);
        }
        return result;
    }
}

