/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.page;

import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.N2oAbstractDatasource;
import net.n2oapp.framework.api.metadata.ReduxModelEnum;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.global.view.page.N2oBreadcrumb;
import net.n2oapp.framework.api.metadata.global.view.page.N2oPage;
import net.n2oapp.framework.api.metadata.global.view.page.datasource.N2oApplicationDatasource;
import net.n2oapp.framework.api.metadata.global.view.page.datasource.N2oParentDatasource;
import net.n2oapp.framework.api.metadata.global.view.page.datasource.N2oStandardDatasource;
import net.n2oapp.framework.api.metadata.global.view.widget.N2oWidget;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oAbstractButton;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oToolbar;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.ToolbarItem;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.Breadcrumb;
import net.n2oapp.framework.api.metadata.meta.BreadcrumbList;
import net.n2oapp.framework.api.metadata.meta.Models;
import net.n2oapp.framework.api.metadata.meta.page.Page;
import net.n2oapp.framework.api.metadata.meta.page.PageProperty;
import net.n2oapp.framework.api.metadata.meta.page.PageRoutes;
import net.n2oapp.framework.config.metadata.compile.BaseSourceCompiler;
import net.n2oapp.framework.config.metadata.compile.ComponentCompiler;
import net.n2oapp.framework.config.metadata.compile.N2oCompileProcessor;
import net.n2oapp.framework.config.metadata.compile.context.ModalPageContext;
import net.n2oapp.framework.config.metadata.compile.context.PageContext;
import net.n2oapp.framework.config.metadata.compile.datasource.ClientDatasourceIdsScope;
import net.n2oapp.framework.config.metadata.compile.datasource.DataSourcesScope;
import net.n2oapp.framework.config.metadata.compile.page.PageScope;
import net.n2oapp.framework.config.register.route.RouteUtil;

public abstract class PageCompiler<S extends N2oPage, C extends Page>
extends ComponentCompiler<C, S, PageContext>
implements BaseSourceCompiler<C, S, PageContext> {
    protected void compileBaseProperties(S source, C page, PageContext context, CompileProcessor p) {
        page.setId((String)CompileUtil.castDefault((Object)context.getClientPageId(), (Supplier[])new Supplier[]{() -> RouteUtil.convertPathToId(this.initPageRoute((N2oPage)source, context, p))}));
        Models models = new Models();
        page.setModels(models);
        page.getPageProperty().setModel((ReduxModelEnum)CompileUtil.castDefault((Object)source.getModel(), (Object)ReduxModelEnum.RESOLVE, (Object[])new ReduxModelEnum[0]));
    }

    protected String initPageRoute(N2oPage source, PageContext context, CompileProcessor p) {
        return RouteUtil.normalize((String)CompileUtil.castDefault((Object)context.getRoute((N2oCompileProcessor)p), (Object)source.getRoute(), (Object[])new String[]{RouteUtil.normalize(source.getId())}));
    }

    protected void registerRoutes(PageRoutes routes, PageContext context, CompileProcessor p) {
        for (String route : routes.getSet()) {
            p.addRoute(route, (CompileContext)context);
        }
    }

    protected BreadcrumbList initBreadcrumb(N2oPage source, String pageName, PageContext context, CompileProcessor p) {
        boolean needCreation;
        if (Boolean.TRUE.equals(context.getBreadcrumbFromParent())) {
            BreadcrumbList breadcrumbList = new BreadcrumbList();
            for (Breadcrumb breadcrumb : context.getBreadcrumbs()) {
                breadcrumb.setPath(this.resolvePath(breadcrumb.getPath(), context));
                breadcrumb.setModelLinks(context.getParentModelLinks());
                breadcrumbList.add((Object)breadcrumb);
            }
            return breadcrumbList;
        }
        boolean bl = needCreation = source.getHasBreadcrumbs() != false || (Boolean)p.resolve(Placeholders.property((String)"n2o.api.page.breadcrumbs"), Boolean.class) != false;
        if (needCreation) {
            if (source.getBreadcrumbs() == null) {
                return this.initBreadcrumbByContext(pageName, context);
            }
            BreadcrumbList breadcrumbs = new BreadcrumbList();
            for (N2oBreadcrumb sourceCrumb : source.getBreadcrumbs()) {
                breadcrumbs.add((Object)new Breadcrumb(p.resolveJS(sourceCrumb.getLabel()), this.resolvePath(sourceCrumb.getPath(), context)));
            }
            return breadcrumbs;
        }
        return null;
    }

    private String resolvePath(String path, PageContext context) {
        if (!RouteUtil.hasRelativity(path)) {
            return path;
        }
        Integer nestingLevel = RouteUtil.getRelativeLevel(path);
        N2oException noRouteException = new N2oException("\u0420\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u043c\u0430\u0440\u0448\u0440\u0443\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0434\u043b\u044f \u043f\u0443\u0442\u0438 '" + path + "'");
        List parentRoutes = Objects.requireNonNullElseGet(context.getParentRoutes(), () -> {
            throw noRouteException;
        });
        if (nestingLevel > parentRoutes.size()) {
            throw noRouteException;
        }
        return Objects.requireNonNullElseGet((String)parentRoutes.get(parentRoutes.size() - nestingLevel), () -> {
            throw noRouteException;
        });
    }

    protected BreadcrumbList initBreadcrumbByContext(String pageName, PageContext context) {
        if (context instanceof ModalPageContext) {
            return null;
        }
        BreadcrumbList breadcrumbs = new BreadcrumbList();
        if (context.getBreadcrumbs() != null && !context.getBreadcrumbs().isEmpty()) {
            for (Breadcrumb breadcrumb : context.getBreadcrumbs()) {
                breadcrumbs.add((Object)new Breadcrumb(breadcrumb));
            }
            Breadcrumb prev = (Breadcrumb)breadcrumbs.get(breadcrumbs.size() - 1);
            prev.setPath((String)CompileUtil.castDefault((Object)prev.getPath(), (Object)context.getParentRoute(), (Object[])new String[]{"/"}));
        }
        Breadcrumb current = new Breadcrumb();
        current.setLabel(pageName);
        if (context.getParentModelLinks() != null) {
            current.setModelLinks(context.getParentModelLinks());
        }
        breadcrumbs.add((Object)current);
        return breadcrumbs;
    }

    protected PageProperty initPageName(N2oPage source, String pageName, PageContext context, CompileProcessor p) {
        PageProperty pageProperty = new PageProperty();
        boolean showTitle = (Boolean)CompileUtil.castDefault((Object)source.getShowTitle(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)"n2o.api.page.show_title"), Boolean.class)});
        pageProperty.setHtmlTitle((String)CompileUtil.castDefault((Object)source.getHtmlTitle(), (Object)pageName, (Object[])new String[0]));
        if (context instanceof ModalPageContext) {
            pageProperty.setModalHeaderTitle(pageName);
        } else if (showTitle) {
            pageProperty.setTitle((String)CompileUtil.castDefault((Object)source.getTitle(), (Object)pageName, (Object[])new String[0]));
        }
        if (context.getParentModelLinks() != null) {
            pageProperty.setModelLinks(context.getParentModelLinks());
        }
        return pageProperty;
    }

    protected void initContextDatasources(DataSourcesScope dataSourcesScope, ClientDatasourceIdsScope clientDatasourceIdsScope, PageScope pageScope, PageContext context, CompileProcessor p) {
        if (context.getDatasources() != null) {
            for (N2oAbstractDatasource ctxDs : context.getDatasources()) {
                String dsId = ctxDs.getId() != null ? ctxDs.getId() : pageScope.getResultWidgetId();
                ctxDs.setId(dsId);
                if (dataSourcesScope.containsKey(dsId) && ctxDs instanceof N2oStandardDatasource) {
                    dataSourcesScope.put(dsId, (N2oAbstractDatasource)p.merge((Source)((N2oAbstractDatasource)dataSourcesScope.get(dsId)), (Source)ctxDs));
                    continue;
                }
                if (ctxDs instanceof N2oApplicationDatasource) {
                    N2oApplicationDatasource applicationDatasource = (N2oApplicationDatasource)ctxDs;
                    clientDatasourceIdsScope.put(ctxDs.getId(), (String)CompileUtil.castDefault((Object)applicationDatasource.getSourceDatasource(), (Object)ctxDs.getId(), (Object[])new String[0]));
                } else if (ctxDs instanceof N2oParentDatasource) {
                    N2oParentDatasource parentDatasource = (N2oParentDatasource)ctxDs;
                    String sourceDatasourceId = (String)CompileUtil.castDefault((Object)parentDatasource.getSourceDatasource(), (Object)ctxDs.getId(), (Object[])new String[0]);
                    if (context.getParentDatasourceIdsMap().containsKey(sourceDatasourceId)) {
                        clientDatasourceIdsScope.put(dsId, context.getParentDatasourceIdsMap().get(sourceDatasourceId));
                    }
                }
                dataSourcesScope.put(dsId, ctxDs);
            }
        }
    }

    protected N2oToolbar cloneToolbar(N2oToolbar t, N2oWidget resultWidget, CompileProcessor p) {
        N2oToolbar toolbar = new N2oToolbar();
        toolbar.setPlace((String)CompileUtil.castDefault((Object)t.getPlace(), (Supplier[])new Supplier[]{() -> (String)p.resolve(Placeholders.property((String)"n2o.api.page.toolbar.place"), String.class)}));
        toolbar.setGenerate(t.getGenerate());
        toolbar.setStyle(t.getStyle());
        toolbar.setDatasourceId(t.getDatasourceId());
        toolbar.setCssClass(t.getCssClass());
        if (t.getItems() != null) {
            ToolbarItem[] items = new ToolbarItem[t.getItems().length];
            for (int i = 0; i < t.getItems().length; ++i) {
                items[i] = (ToolbarItem)CompileUtil.copy((Object)t.getItems()[i]);
                if (!N2oAbstractButton.class.isAssignableFrom(items[i].getClass())) continue;
                ((N2oAbstractButton)items[i]).setDatasourceId(((N2oAbstractButton)items[i]).getDatasourceId() == null ? resultWidget.getDatasourceId() : ((N2oAbstractButton)items[i]).getDatasourceId());
            }
            toolbar.setItems(items);
        }
        return toolbar;
    }
}

