/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.page;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.global.view.page.N2oLeftRightPage;
import net.n2oapp.framework.api.metadata.meta.page.StandardPage;
import net.n2oapp.framework.api.metadata.meta.region.Region;
import net.n2oapp.framework.config.metadata.compile.context.PageContext;
import net.n2oapp.framework.config.metadata.compile.page.BasePageCompiler;
import org.springframework.stereotype.Component;

@Component
public class LeftRightPageCompiler
extends BasePageCompiler<N2oLeftRightPage, StandardPage> {
    public StandardPage compile(N2oLeftRightPage source, PageContext context, CompileProcessor p) {
        StandardPage page = new StandardPage();
        if (source.getLeftWidth() != null && !source.getLeftWidth().isEmpty() || source.getRightWidth() != null && !source.getRightWidth().isEmpty()) {
            StandardPage standardPage = page;
            Objects.requireNonNull(standardPage);
            page.setWidth(new StandardPage.RegionWidth(standardPage, StringUtils.prepareSizeAttribute((String)source.getLeftWidth()), StringUtils.prepareSizeAttribute((String)source.getRightWidth())));
        }
        return this.compilePage(source, page, context, p, null);
    }

    @Override
    protected Map<String, List<Region>> initRegions(N2oLeftRightPage source, StandardPage page, CompileProcessor p, PageContext context, Object ... scopes) {
        HashMap<String, List<Region>> regions = new HashMap<String, List<Region>>();
        this.initRegions(source.getLeft(), regions, "left", context, p, scopes);
        this.initRegions(source.getRight(), regions, "right", context, p, scopes);
        return regions;
    }

    public Class<? extends Source> getSourceClass() {
        return N2oLeftRightPage.class;
    }

    @Override
    protected String getSrcProperty() {
        return "n2o.api.page.left_right.src";
    }
}

