/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.fieldset;

import java.util.ArrayList;
import java.util.Objects;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.ExtensionAttributesAware;
import net.n2oapp.framework.api.metadata.aware.FieldsetItem;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.control.N2oField;
import net.n2oapp.framework.api.metadata.global.view.fieldset.N2oFieldSet;
import net.n2oapp.framework.api.metadata.global.view.fieldset.N2oFieldsetCol;
import net.n2oapp.framework.api.metadata.global.view.fieldset.N2oSetFieldSet;
import net.n2oapp.framework.api.metadata.meta.control.Field;
import net.n2oapp.framework.api.metadata.meta.fieldset.FieldSet;
import net.n2oapp.framework.api.script.ScriptProcessor;
import net.n2oapp.framework.config.metadata.compile.BaseSourceCompiler;
import net.n2oapp.framework.config.metadata.compile.fieldset.FieldSetVisibilityScope;
import net.n2oapp.framework.config.util.StylesResolver;
import org.springframework.stereotype.Component;

@Component
public class FieldSetColumnCompiler
implements BaseSourceCompiler<FieldSet.Column, N2oFieldsetCol, CompileContext<?, ?>> {
    public FieldSet.Column compile(N2oFieldsetCol source, CompileContext<?, ?> context, CompileProcessor p) {
        FieldSet.Column column = new FieldSet.Column();
        column.setClassName(source.getCssClass());
        column.setStyle(StylesResolver.resolveStyles(source.getStyle()));
        column.setSize(source.getSize());
        column.setProperties(p.mapAttributes((ExtensionAttributesAware)source));
        column.setVisible(ScriptProcessor.resolveExpression((String)source.getVisible()));
        FieldSetVisibilityScope scope = this.initVisibilityScope(source, p);
        if (source.getItems() != null && source.getItems().length > 0) {
            boolean onlyFields = true;
            for (FieldsetItem item : source.getItems()) {
                if (item instanceof N2oField) continue;
                onlyFields = false;
                break;
            }
            if (onlyFields) {
                ArrayList<Field> compiledFields = new ArrayList<Field>();
                for (FieldsetItem field : source.getItems()) {
                    compiledFields.add((Field)p.compile((Object)field, context, new Object[]{scope}));
                }
                column.setFields(compiledFields);
            } else {
                ArrayList<FieldSet> fieldSets = new ArrayList<FieldSet>();
                int i = 0;
                while (i < source.getItems().length) {
                    N2oFieldSet n2oFieldSet;
                    FieldsetItem field = source.getItems()[i];
                    if (field instanceof N2oFieldSet) {
                        N2oFieldSet fieldSet;
                        n2oFieldSet = fieldSet = (N2oFieldSet)field;
                        ++i;
                    } else {
                        N2oSetFieldSet newFieldSet = new N2oSetFieldSet();
                        ArrayList<FieldsetItem> fieldSetItems = new ArrayList<FieldsetItem>();
                        while (i < source.getItems().length && !(source.getItems()[i] instanceof N2oFieldSet)) {
                            fieldSetItems.add(source.getItems()[i]);
                            ++i;
                        }
                        FieldsetItem[] items = new FieldsetItem[fieldSetItems.size()];
                        newFieldSet.setItems(fieldSetItems.toArray(items));
                        n2oFieldSet = newFieldSet;
                    }
                    fieldSets.add((FieldSet)p.compile((Object)n2oFieldSet, context, new Object[]{scope}));
                }
                column.setFieldsets(fieldSets);
            }
        }
        return column;
    }

    public Class<? extends Source> getSourceClass() {
        return N2oFieldsetCol.class;
    }

    private FieldSetVisibilityScope initVisibilityScope(N2oFieldsetCol source, CompileProcessor p) {
        FieldSetVisibilityScope scope = new FieldSetVisibilityScope((FieldSetVisibilityScope)p.getScope(FieldSetVisibilityScope.class));
        if (source.getVisible() != null && !Objects.equals(source.getVisible(), "true")) {
            String value = p.resolveJS(source.getVisible());
            if (StringUtils.isJs((Object)value)) {
                scope.add(StringUtils.unwrapJs((String)value));
            } else {
                scope.add(value);
            }
        }
        return scope;
    }
}

