/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.datasource;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.metadata.ReduxModelEnum;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.datasource.InheritedDatasource;
import net.n2oapp.framework.api.metadata.global.dao.N2oPreFilter;
import net.n2oapp.framework.api.metadata.global.view.page.datasource.N2oInheritedDatasource;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.ModelLink;
import net.n2oapp.framework.api.script.ScriptProcessor;
import net.n2oapp.framework.config.metadata.compile.ParentRouteScope;
import net.n2oapp.framework.config.metadata.compile.datasource.BaseDatasourceCompiler;
import net.n2oapp.framework.config.util.DatasourceUtil;
import org.springframework.stereotype.Component;

@Component
public class InheritedDatasourceCompiler
extends BaseDatasourceCompiler<N2oInheritedDatasource, InheritedDatasource> {
    public Class<? extends Source> getSourceClass() {
        return N2oInheritedDatasource.class;
    }

    public InheritedDatasource compile(N2oInheritedDatasource source, CompileContext<?, ?> context, CompileProcessor p) {
        InheritedDatasource compiled = new InheritedDatasource();
        this.compileDatasource(source, compiled, p);
        compiled.setProvider(this.initProvider(source, p));
        compiled.setSubmit(this.initSubmit(source, p));
        compiled.getProvider().setFilters(this.initFilters(source, p));
        return compiled;
    }

    private InheritedDatasource.Submit initSubmit(N2oInheritedDatasource source, CompileProcessor p) {
        if (source.getSubmit() == null) {
            return null;
        }
        InheritedDatasource.Submit submit = new InheritedDatasource.Submit();
        N2oInheritedDatasource.Submit sourceSubmit = source.getSubmit();
        submit.setAuto((Boolean)CompileUtil.castDefault((Object)sourceSubmit.getAuto(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)"n2o.api.datasource.inherited.submit.auto"), Boolean.class)}));
        submit.setModel((ReduxModelEnum)CompileUtil.castDefault((Object)sourceSubmit.getModel(), (Object)ReduxModelEnum.RESOLVE, (Object[])new ReduxModelEnum[0]));
        submit.setTargetDs(DatasourceUtil.getClientDatasourceId((String)CompileUtil.castDefault((Object)sourceSubmit.getTargetDatasource(), (Object)source.getSourceDatasource(), (Object[])new String[0]), p));
        submit.setTargetModel((ReduxModelEnum)CompileUtil.castDefault((Object)sourceSubmit.getTargetModel(), (Object)source.getSourceModel(), (Object[])new ReduxModelEnum[]{ReduxModelEnum.RESOLVE}));
        submit.setTargetField(sourceSubmit.getTargetDatasource() != null ? sourceSubmit.getTargetFieldId() : source.getSourceFieldId());
        submit.setSubmitValueExpression(ScriptProcessor.resolveFunction((String)source.getSubmit().getSubmitValue()));
        return submit;
    }

    private InheritedDatasource.Provider initProvider(N2oInheritedDatasource source, CompileProcessor p) {
        InheritedDatasource.Provider provider = new InheritedDatasource.Provider();
        provider.setSourceDs(DatasourceUtil.getClientDatasourceId(source.getSourceDatasource(), p));
        provider.setSourceModel((ReduxModelEnum)CompileUtil.castDefault((Object)source.getSourceModel(), (Object)ReduxModelEnum.RESOLVE, (Object[])new ReduxModelEnum[0]));
        provider.setSourceField(source.getSourceFieldId());
        provider.setFetchValueExpression(ScriptProcessor.resolveFunction((String)source.getFetchValue()));
        return provider;
    }

    private List<InheritedDatasource.Filter> initFilters(N2oInheritedDatasource source, CompileProcessor p) {
        if (source.getFilters() == null) {
            return null;
        }
        ArrayList<InheritedDatasource.Filter> filters = new ArrayList<InheritedDatasource.Filter>();
        for (N2oPreFilter sourceFilter : source.getFilters()) {
            InheritedDatasource.Filter filter = new InheritedDatasource.Filter();
            filter.setType(sourceFilter.getType());
            filter.setFieldId(sourceFilter.getFieldId());
            boolean required = (Boolean)CompileUtil.castDefault((Object)sourceFilter.getRequired(), (Object)false, (Object[])new Boolean[0]);
            filter.setRequired(Boolean.valueOf(required));
            Object value = this.getPrefilterValue(sourceFilter);
            ParentRouteScope routeScope = (ParentRouteScope)p.getScope(ParentRouteScope.class);
            if (routeScope != null && routeScope.getQueryMapping() != null && routeScope.getQueryMapping().containsKey(sourceFilter.getParam())) {
                filter.setModelLink(routeScope.getQueryMapping().get(sourceFilter.getParam()));
            } else if (StringUtils.isJs((Object)value)) {
                String clientDatasourceId = sourceFilter.getRefPageId() != null ? DatasourceUtil.getClientDatasourceId(sourceFilter.getDatasourceId(), sourceFilter.getRefPageId(), p) : DatasourceUtil.getClientDatasourceId(sourceFilter.getDatasourceId(), p);
                ReduxModelEnum model = (ReduxModelEnum)CompileUtil.castDefault((Object)sourceFilter.getModel(), (Object)ReduxModelEnum.RESOLVE, (Object[])new ReduxModelEnum[0]);
                ModelLink link = new ModelLink(model, clientDatasourceId);
                link.setValue(value);
                link.setParam(sourceFilter.getParam());
                link.setRequired(required);
                filter.setModelLink(link);
            } else {
                ModelLink link = new ModelLink(value);
                link.setParam(sourceFilter.getParam());
                link.setRequired(required);
                filter.setModelLink(link);
            }
            filters.add(filter);
        }
        return filters;
    }

    private Object getPrefilterValue(N2oPreFilter n2oPreFilter) {
        return n2oPreFilter.getValues() == null ? ScriptProcessor.resolveExpression((String)n2oPreFilter.getValue()) : ScriptProcessor.resolveArrayExpression((String[])n2oPreFilter.getValues());
    }
}

