/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.datasource;

import java.util.function.Supplier;
import net.n2oapp.framework.api.metadata.ReduxModelEnum;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.datasource.BrowserStorageDatasource;
import net.n2oapp.framework.api.metadata.datasource.BrowserStorageTypeEnum;
import net.n2oapp.framework.api.metadata.global.view.page.datasource.N2oBrowserStorageDatasource;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.config.metadata.compile.datasource.BaseDatasourceCompiler;
import org.springframework.stereotype.Component;

@Component
public class BrowserStorageDatasourceCompiler
extends BaseDatasourceCompiler<N2oBrowserStorageDatasource, BrowserStorageDatasource> {
    public Class<? extends Source> getSourceClass() {
        return N2oBrowserStorageDatasource.class;
    }

    public BrowserStorageDatasource compile(N2oBrowserStorageDatasource source, CompileContext<?, ?> context, CompileProcessor p) {
        BrowserStorageDatasource compiled = new BrowserStorageDatasource();
        this.compileDatasource(source, compiled, p);
        compiled.setProvider(this.initProvider(source, p));
        compiled.setSubmit(this.initSubmit(source, p));
        compiled.setFetchOnInit((Boolean)CompileUtil.castDefault((Object)source.getFetchOnInit(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)"n2o.api.datasource.browser.fetch_on_init"), Boolean.class)}));
        return compiled;
    }

    private BrowserStorageDatasource.Provider initProvider(N2oBrowserStorageDatasource source, CompileProcessor p) {
        BrowserStorageDatasource.Provider provider = new BrowserStorageDatasource.Provider();
        provider.setKey((String)CompileUtil.castDefault((Object)source.getKey(), (Object)source.getId(), (Object[])new String[0]));
        provider.setStorage((BrowserStorageTypeEnum)CompileUtil.castDefault((Object)source.getStorageType(), (Supplier[])new Supplier[]{() -> (BrowserStorageTypeEnum)p.resolve(Placeholders.property((String)"n2o.api.datasource.browser.storage_type"), BrowserStorageTypeEnum.class)}));
        return provider;
    }

    private BrowserStorageDatasource.Submit initSubmit(N2oBrowserStorageDatasource source, CompileProcessor p) {
        if (source.getSubmit() == null) {
            return null;
        }
        BrowserStorageDatasource.Submit submit = new BrowserStorageDatasource.Submit();
        submit.setKey((String)CompileUtil.castDefault((Object)source.getSubmit().getKey(), (Object)source.getKey(), (Object[])new String[]{source.getId()}));
        submit.setAuto((Boolean)CompileUtil.castDefault((Object)source.getSubmit().getAuto(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)"n2o.api.datasource.browser.submit.auto"), Boolean.class)}));
        submit.setModel((ReduxModelEnum)CompileUtil.castDefault((Object)source.getSubmit().getModel(), (Object)ReduxModelEnum.RESOLVE, (Object[])new ReduxModelEnum[0]));
        submit.setStorage((BrowserStorageTypeEnum)CompileUtil.castDefault((Object)source.getSubmit().getStorageType(), (Object)source.getStorageType(), (Object[])new BrowserStorageTypeEnum[]{BrowserStorageTypeEnum.SESSION_STORAGE}));
        return submit;
    }
}

