/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.control;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.function.Supplier;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.control.plain.N2oTextEditor;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.control.StandardField;
import net.n2oapp.framework.api.metadata.meta.control.TextEditor;
import net.n2oapp.framework.config.metadata.compile.control.StandardFieldCompiler;
import net.n2oapp.framework.config.register.storage.PathUtil;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.stereotype.Component;

@Component
public class TextEditorCompiler
extends StandardFieldCompiler<TextEditor, N2oTextEditor> {
    @Override
    protected String getControlSrcProperty() {
        return "n2o.api.control.text_editor.src";
    }

    public Class<? extends Source> getSourceClass() {
        return N2oTextEditor.class;
    }

    public StandardField<TextEditor> compile(N2oTextEditor source, CompileContext<?, ?> context, CompileProcessor p) {
        TextEditor textEditor = new TextEditor();
        textEditor.setName(p.resolveJS(source.getLabel()));
        this.compileToolbar(source, textEditor, p);
        return this.compileStandardField(textEditor, source, context, p);
    }

    private void compileToolbar(N2oTextEditor source, TextEditor compiled, CompileProcessor p) {
        Map toolbarConfig;
        String toolbarUrl = (String)CompileUtil.castDefault((Object)source.getToolbarUrl(), (Supplier[])new Supplier[]{() -> (String)p.resolve(Placeholders.property((String)"n2o.api.control.text_editor.toolbar_url"), String.class)});
        if (toolbarUrl == null) {
            return;
        }
        PathMatchingResourcePatternResolver r = new PathMatchingResourcePatternResolver();
        ObjectMapper mapper = new ObjectMapper();
        try (InputStream is = r.getResource(PathUtil.convertPathToClasspathUri(toolbarUrl)).getInputStream();){
            toolbarConfig = (Map)mapper.readValue(is, Map.class);
        }
        catch (IOException e) {
            throw new N2oException((Throwable)e);
        }
        compiled.setToolbarConfig((Object)toolbarConfig);
    }
}

