/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.control;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.aware.PreFiltersAware;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.control.N2oListField;
import net.n2oapp.framework.api.metadata.dataprovider.N2oClientDataProvider;
import net.n2oapp.framework.api.metadata.global.dao.N2oPreFilter;
import net.n2oapp.framework.api.metadata.local.CompiledQuery;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.local.view.widget.util.SubModelQuery;
import net.n2oapp.framework.api.metadata.meta.BindLink;
import net.n2oapp.framework.api.metadata.meta.ModelLink;
import net.n2oapp.framework.api.metadata.meta.ReduxAction;
import net.n2oapp.framework.api.metadata.meta.badge.BadgeUtil;
import net.n2oapp.framework.api.metadata.meta.control.ControlDependency;
import net.n2oapp.framework.api.metadata.meta.control.DefaultValues;
import net.n2oapp.framework.api.metadata.meta.control.ListControl;
import net.n2oapp.framework.api.metadata.meta.control.StandardField;
import net.n2oapp.framework.api.metadata.meta.control.ValidationTypeEnum;
import net.n2oapp.framework.api.metadata.meta.widget.WidgetParamScope;
import net.n2oapp.framework.config.metadata.compile.context.QueryContext;
import net.n2oapp.framework.config.metadata.compile.control.StandardFieldCompiler;
import net.n2oapp.framework.config.metadata.compile.dataprovider.ClientDataProviderUtil;
import net.n2oapp.framework.config.metadata.compile.fieldset.MultiFieldSetScope;
import net.n2oapp.framework.config.metadata.compile.redux.Redux;
import net.n2oapp.framework.config.metadata.compile.widget.SubModelsScope;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import net.n2oapp.framework.config.util.DatasourceUtil;
import net.n2oapp.framework.config.util.FieldCompileUtil;
import net.n2oapp.framework.config.util.N2oClientDataProviderUtil;

public abstract class ListControlCompiler<T extends ListControl, S extends N2oListField>
extends StandardFieldCompiler<T, S> {
    private static final String PROPERTY_PREFIX = "n2o.api.control.list";

    protected StandardField<T> compileListControl(T listControl, S source, CompileContext<?, ?> context, CompileProcessor p) {
        listControl.setFormat(p.resolveJS(source.getFormat()));
        listControl.setLabelFieldId((String)CompileUtil.castDefault((Object)p.resolveJS(source.getLabelFieldId()), (Object)"name", (Object[])new String[0]));
        listControl.setSortFieldId((String)CompileUtil.castDefault((Object)source.getSortFieldId(), (Object)listControl.getLabelFieldId(), (Object[])new String[0]));
        listControl.setValueFieldId((String)CompileUtil.castDefault((Object)p.resolveJS(source.getValueFieldId()), (Object)"id", (Object[])new String[0]));
        listControl.setIconFieldId(p.resolveJS(source.getIconFieldId()));
        listControl.setImageFieldId(p.resolveJS(source.getImageFieldId()));
        listControl.setGroupFieldId(p.resolveJS(source.getGroupFieldId()));
        listControl.setHasSearch(source.getSearch());
        listControl.setStatusFieldId(source.getStatusFieldId());
        this.compileData(source, listControl, context, p);
        listControl.setCaching((Boolean)CompileUtil.castDefault((Object)source.getCache(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)"n2o.api.control.list.cache"), Boolean.class)}));
        listControl.setEnabledFieldId(source.getEnabledFieldId());
        listControl.setBadge(BadgeUtil.compileReferringBadge(source, (String)PROPERTY_PREFIX, (CompileProcessor)p));
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = () -> source.getSize();
        supplierArray[1] = () -> (Integer)p.resolve(Placeholders.property((String)"n2o.api.control.list.size"), Integer.class);
        listControl.setSize((Integer)CompileUtil.castDefault((Object)listControl.getSize(), (Supplier[])supplierArray));
        this.initSubModel(source, listControl.getData(), p);
        return this.compileStandardField(listControl, source, context, p);
    }

    protected void compileData(S source, T listControl, CompileContext<?, ?> context, CompileProcessor p) {
        if (source.getQueryId() != null) {
            this.initDataProvider(listControl, (N2oListField)source, context, p);
        } else if (source.getDatasourceId() != null) {
            listControl.setDatasource(DatasourceUtil.getClientDatasourceId(source.getDatasourceId(), p));
            listControl.setQuickSearchParam(source.getDatasourceId() + "_" + (String)CompileUtil.castDefault((Object)source.getSearchFilterId(), (Object)listControl.getLabelFieldId(), (Object[])new String[0]));
        } else if (source.getOptions() != null) {
            ArrayList<DataSet> list = new ArrayList<DataSet>();
            for (Map option : source.getOptions()) {
                DataSet dataItem = new DataSet();
                option.forEach((f, v) -> dataItem.put(f, p.resolve(v)));
                list.add(dataItem);
            }
            listControl.setData(list);
        }
    }

    @Override
    protected Object compileDefValues(S source, CompileProcessor p) {
        if (source.getDefValue() == null) {
            return null;
        }
        DefaultValues values = new DefaultValues();
        values.setValues(new HashMap());
        source.getDefValue().forEach((f, v) -> values.getValues().put(f, p.resolve(v)));
        return source.isSingle() ? values : Collections.singletonList(values);
    }

    @Override
    protected void compileParams(StandardField<T> control, S source, WidgetParamScope paramScope, CompileProcessor p) {
        if (source.getParam() == null) {
            return;
        }
        String id = control.getId() + ".id";
        WidgetScope modelsScope = (WidgetScope)p.getScope(WidgetScope.class);
        if (modelsScope != null) {
            ModelLink onSet = this.compileLinkOnSet(control, source, modelsScope, p);
            ReduxAction onGet = Redux.dispatchUpdateModel(modelsScope.getClientDatasourceId(), modelsScope.getModel(), id, Placeholders.colon((String)source.getParam()));
            paramScope.addQueryMapping(source.getParam(), onGet, (BindLink)onSet);
        }
    }

    protected ModelLink compileLinkOnSet(StandardField<T> control, S source, WidgetScope widgetScope, CompileProcessor p) {
        ModelLink onSet = new ModelLink(widgetScope.getModel(), widgetScope.getClientDatasourceId(), control.getId());
        onSet.setParam(source.getParam());
        onSet.setSubModelQuery(this.createSubModel((N2oListField)source, ((ListControl)control.getControl()).getData(), p));
        onSet.setValue((Object)"`id`");
        return onSet;
    }

    protected StandardField<T> compileFetchDependencies(StandardField<T> field, S source, CompileProcessor p) {
        if (source.getPreFilters() != null && field.getDependencies().stream().noneMatch(d -> d.getType() == ValidationTypeEnum.FETCH)) {
            HashSet<String> setOn = new HashSet<String>();
            for (N2oPreFilter filter : source.getPreFilters()) {
                if (!StringUtils.hasLink((String)filter.getValue())) continue;
                String resolveOnJS = p.resolveJS(filter.getValue());
                resolveOnJS = resolveOnJS.substring(1, resolveOnJS.length() - 1);
                setOn.add(resolveOnJS);
            }
            if (!setOn.isEmpty()) {
                ControlDependency fetchCD = new ControlDependency();
                fetchCD.setType(ValidationTypeEnum.FETCH);
                fetchCD.setOn(new ArrayList(setOn));
                field.addDependency(fetchCD);
            }
        }
        return field;
    }

    private void initSubModel(S source, List<Map<String, Object>> data, CompileProcessor p) {
        SubModelsScope scope = (SubModelsScope)p.getScope(SubModelsScope.class);
        WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
        if (scope == null || widgetScope == null) {
            return;
        }
        if (source.getQueryId() != null || data != null) {
            scope.add(this.createSubModel((N2oListField)source, data, p), widgetScope.getDatasourceId());
        }
    }

    protected SubModelQuery createSubModel(N2oListField item, List<Map<String, Object>> data, CompileProcessor p) {
        MultiFieldSetScope multiFieldSetScope = (MultiFieldSetScope)p.getScope(MultiFieldSetScope.class);
        return new SubModelQuery(multiFieldSetScope == null ? null : multiFieldSetScope.getPathWithIndexes(), item.getId(), item.getQueryId(), item.getValueFieldId() != null ? item.getValueFieldId() : "id", item.getLabelFieldId() != null ? item.getLabelFieldId() : "name", !item.isSingle(), data);
    }

    private void initDataProvider(T listControl, N2oListField source, CompileContext<?, ?> context, CompileProcessor p) {
        N2oClientDataProvider dataProvider = N2oClientDataProviderUtil.initFromField(source.getPreFilters(), source.getQueryId(), p);
        source.addDependencies(FieldCompileUtil.getResetOnChangeDependency((PreFiltersAware)source));
        dataProvider.setQuickSearchParam(this.initQuickSearchParam(listControl, source, p));
        listControl.setDataProvider(ClientDataProviderUtil.compile(dataProvider, context, p));
    }

    protected String initQuickSearchParam(T listControl, N2oListField source, CompileProcessor p) {
        QueryContext queryContext = new QueryContext(source.getQueryId());
        CompiledQuery query = (CompiledQuery)p.getCompiled((CompileContext)queryContext);
        if (Boolean.TRUE.equals(listControl.getHasSearch())) {
            String searchFilterId = (String)CompileUtil.castDefault((Object)source.getSearchFilterId(), (Object)listControl.getLabelFieldId(), (Object[])new String[0]);
            if (query.getFilterIdToParamMap().containsKey(searchFilterId)) {
                return (String)query.getFilterIdToParamMap().get(searchFilterId);
            }
            if (searchFilterId != null && listControl.getHasSearch().booleanValue()) {
                throw new N2oException(String.format("\u0414\u043b\u044f \u043f\u043e\u043b\u044f '%s' \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0437\u0430\u0434\u0430\u0442\u044c \u0444\u0438\u043b\u044c\u0442\u0440 \u0432 '%s.query.xml'", searchFilterId, query.getId()));
            }
        }
        return null;
    }
}

