/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.control;

import java.math.BigDecimal;
import java.util.function.Supplier;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.control.plain.N2oInputText;
import net.n2oapp.framework.api.metadata.domain.DomainEnum;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.control.InputText;
import net.n2oapp.framework.api.metadata.meta.control.StandardField;
import net.n2oapp.framework.config.metadata.compile.control.StandardFieldCompiler;
import org.springframework.stereotype.Component;

@Component
public class InputTextCompiler
extends StandardFieldCompiler<InputText, N2oInputText> {
    @Override
    protected String getControlSrcProperty() {
        return "n2o.api.control.input.number.src";
    }

    public Class<? extends Source> getSourceClass() {
        return N2oInputText.class;
    }

    public StandardField<InputText> compile(N2oInputText source, CompileContext<?, ?> context, CompileProcessor p) {
        InputText inputText = new InputText();
        inputText.setMeasure(source.getMeasure());
        inputText.setAutocomplete((String)CompileUtil.castDefault((Object)source.getAutocomplete(), (Supplier[])new Supplier[]{() -> (String)p.resolve(Placeholders.property((String)"n2o.api.control.input_text.autocomplete"), String.class)}));
        this.compileDomain(inputText, source, p);
        if (source.getStep() != null && source.getStep().replace(",", "").replace(".", "").replace("0", "").isEmpty()) {
            inputText.setShowButtons(Boolean.valueOf(false));
        }
        return this.compileStandardField(inputText, source, context, p);
    }

    private void compileDomain(InputText inputText, N2oInputText source, CompileProcessor p) {
        DomainEnum domain = DomainEnum.getByName((String)source.getDomain());
        if (domain == null) {
            domain = DomainEnum.STRING;
        }
        switch (domain) {
            case INTEGER: {
                inputText.setMin(CompileUtil.castDefault((Object)p.resolveJS(source.getMin(), Integer.class), (Object)Integer.MIN_VALUE, (Object[])new Object[0]));
                inputText.setMax(CompileUtil.castDefault((Object)p.resolveJS(source.getMax(), Integer.class), (Object)Integer.MAX_VALUE, (Object[])new Object[0]));
                inputText.setStep((String)CompileUtil.castDefault((Object)source.getStep(), (Object)"1", (Object[])new String[0]));
                return;
            }
            case LONG: {
                inputText.setMin(CompileUtil.castDefault((Object)p.resolveJS(source.getMin(), Long.class), (Object)"-99999999999999", (Object[])new Object[0]));
                inputText.setMax(CompileUtil.castDefault((Object)p.resolveJS(source.getMax(), Long.class), (Object)"99999999999999", (Object[])new Object[0]));
                inputText.setStep((String)CompileUtil.castDefault((Object)source.getStep(), (Object)"1", (Object[])new String[0]));
                return;
            }
            case SHORT: {
                inputText.setMin(CompileUtil.castDefault((Object)p.resolveJS(source.getMin(), Short.class), (Object)Short.MIN_VALUE, (Object[])new Object[0]));
                inputText.setMax(CompileUtil.castDefault((Object)p.resolveJS(source.getMax(), Short.class), (Object)Short.MAX_VALUE, (Object[])new Object[0]));
                inputText.setStep((String)CompileUtil.castDefault((Object)source.getStep(), (Object)"1", (Object[])new String[0]));
                return;
            }
            case NUMERIC: {
                inputText.setMin(CompileUtil.castDefault((Object)p.resolveJS(source.getMin(), BigDecimal.class), (Object)"-999999999", (Object[])new Object[0]));
                inputText.setMax(CompileUtil.castDefault((Object)p.resolveJS(source.getMax(), BigDecimal.class), (Object)"999999999", (Object[])new Object[0]));
                inputText.setStep((String)CompileUtil.castDefault((Object)source.getStep(), (Object)"0.01", (Object[])new String[0]));
                inputText.setPrecision((Integer)CompileUtil.castDefault((Object)source.getPrecision(), (Supplier[])new Supplier[]{() -> (Integer)p.resolve(Placeholders.property((String)"n2o.api.control.input_text.precision"), Integer.class)}));
                return;
            }
            case STRING: {
                inputText.setLength(source.getLength());
                inputText.setSrc((String)CompileUtil.castDefault((Object)source.getSrc(), (Supplier[])new Supplier[]{() -> (String)p.resolve(Placeholders.property((String)"n2o.api.control.input_text.src"), String.class)}));
                return;
            }
        }
    }
}

