/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.control;

import java.util.HashMap;
import java.util.function.Supplier;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.control.interval.N2oDateInterval;
import net.n2oapp.framework.api.metadata.domain.DomainEnum;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.BindLink;
import net.n2oapp.framework.api.metadata.meta.ModelLink;
import net.n2oapp.framework.api.metadata.meta.ReduxAction;
import net.n2oapp.framework.api.metadata.meta.control.DateInterval;
import net.n2oapp.framework.api.metadata.meta.control.DefaultValues;
import net.n2oapp.framework.api.metadata.meta.control.StandardField;
import net.n2oapp.framework.api.metadata.meta.widget.WidgetParamScope;
import net.n2oapp.framework.config.metadata.compile.control.StandardFieldCompiler;
import net.n2oapp.framework.config.metadata.compile.redux.Redux;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import org.springframework.stereotype.Component;

@Component
public class DateIntervalCompiler
extends StandardFieldCompiler<DateInterval, N2oDateInterval> {
    public Class<? extends Source> getSourceClass() {
        return N2oDateInterval.class;
    }

    public StandardField<DateInterval> compile(N2oDateInterval source, CompileContext<?, ?> context, CompileProcessor p) {
        DateInterval dateInterval = new DateInterval();
        source.setDomain((String)p.resolve(Placeholders.property((String)"n2o.api.control.date_interval.domain"), String.class));
        DomainEnum domain = DomainEnum.getByName((String)source.getDomain());
        if (domain == null || domain.getJsFormat() == null) {
            throw new N2oException("\u041d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0435\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430 'domain' \u0434\u043b\u044f \u043f\u043e\u043b\u044f '" + source.getId() + "'");
        }
        dateInterval.setOutputFormat(domain.getJsFormat());
        dateInterval.setDateFormat((String)CompileUtil.castDefault((Object)source.getDateFormat(), (Supplier[])new Supplier[]{() -> (String)p.resolve(Placeholders.property((String)"n2o.api.control.date_interval.date_format"), String.class)}));
        dateInterval.setTimeFormat(source.getTimeFormat());
        dateInterval.setMin(p.resolveJS(source.getMin()));
        dateInterval.setMax(p.resolveJS(source.getMax()));
        dateInterval.setUtc((Boolean)CompileUtil.castDefault((Object)source.getUtc(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)"n2o.api.control.date_interval.utc"), Boolean.class)}));
        return this.compileStandardField(dateInterval, source, context, p);
    }

    @Override
    protected Object compileDefValues(N2oDateInterval source, CompileProcessor p) {
        if (source.getBegin() == null && source.getEnd() == null) {
            return null;
        }
        DefaultValues values = new DefaultValues();
        values.setValues(new HashMap());
        if (source.getBegin() != null) {
            values.getValues().put("begin", source.getBegin());
        }
        if (source.getEnd() != null) {
            values.getValues().put("end", source.getEnd());
        }
        return values;
    }

    @Override
    protected void compileParams(StandardField<DateInterval> control, N2oDateInterval source, WidgetParamScope paramScope, CompileProcessor p) {
        ReduxAction onGet;
        ModelLink onSet;
        String fieldId;
        if (source.getBeginParam() == null && source.getEndParam() == null) {
            return;
        }
        WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
        if (widgetScope == null) {
            return;
        }
        if (source.getBeginParam() != null) {
            fieldId = control.getId() + ".begin";
            onSet = new ModelLink(widgetScope.getModel(), widgetScope.getClientDatasourceId(), fieldId);
            onSet.setParam(source.getBeginParam());
            onGet = Redux.dispatchUpdateModel(widgetScope.getClientDatasourceId(), widgetScope.getModel(), fieldId, Placeholders.colon((String)source.getBeginParam()));
            paramScope.addQueryMapping(source.getBeginParam(), onGet, (BindLink)onSet);
        }
        if (source.getEndParam() != null) {
            fieldId = control.getId() + ".end";
            onSet = new ModelLink(widgetScope.getModel(), widgetScope.getClientDatasourceId(), fieldId);
            onSet.setParam(source.getEndParam());
            onGet = Redux.dispatchUpdateModel(widgetScope.getClientDatasourceId(), widgetScope.getModel(), fieldId, Placeholders.colon((String)source.getEndParam()));
            paramScope.addQueryMapping(source.getEndParam(), onGet, (BindLink)onSet);
        }
    }

    @Override
    protected String getControlSrcProperty() {
        return "n2o.api.control.date_interval.src";
    }
}

