/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.cell;

import java.util.function.Supplier;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.global.view.widget.table.ShapeTypeEnum;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.N2oBaseColumn;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.cell.N2oBadgeCell;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.badge.PositionEnum;
import net.n2oapp.framework.api.metadata.meta.cell.BadgeCell;
import net.n2oapp.framework.config.metadata.compile.ComponentScope;
import net.n2oapp.framework.config.metadata.compile.cell.AbstractCellCompiler;
import org.springframework.stereotype.Component;

@Component
public class BadgeCellCompiler
extends AbstractCellCompiler<BadgeCell, N2oBadgeCell> {
    public Class<? extends Source> getSourceClass() {
        return N2oBadgeCell.class;
    }

    public BadgeCell compile(N2oBadgeCell source, CompileContext<?, ?> context, CompileProcessor p) {
        N2oBaseColumn column;
        BadgeCell cell = new BadgeCell();
        this.build(cell, source, p, Placeholders.property((String)"n2o.api.cell.badge.src"));
        ComponentScope scope = (ComponentScope)p.getScope(ComponentScope.class);
        if (scope != null && (column = scope.unwrap(N2oBaseColumn.class)) != null) {
            cell.setId(column.getId());
        }
        if (source.getPosition() != null) {
            cell.setPosition(source.getPosition());
        }
        if (source.getText() != null) {
            cell.setText(p.resolveJS(source.getText()));
            cell.setTextFormat(source.getTextFormat());
        }
        if (source.getN2oSwitch() != null) {
            cell.setColor(this.compileSwitch(source.getN2oSwitch(), p));
        } else {
            cell.setColor(p.resolveJS(source.getColor()));
        }
        if (source.getFormat() != null) {
            cell.setFormat(source.getFormat());
        }
        if (source.getImageFieldId() != null) {
            cell.setImageFieldId(source.getImageFieldId());
            cell.setImageShape((ShapeTypeEnum)CompileUtil.castDefault((Object)source.getImageShape(), (Supplier[])new Supplier[]{() -> (ShapeTypeEnum)p.resolve(Placeholders.property((String)"n2o.api.cell.badge.image_shape"), ShapeTypeEnum.class)}));
            cell.setImagePosition((PositionEnum)CompileUtil.castDefault((Object)source.getImagePosition(), (Supplier[])new Supplier[]{() -> (PositionEnum)p.resolve(Placeholders.property((String)"n2o.api.cell.badge.image_position"), PositionEnum.class)}));
        }
        cell.setShape((ShapeTypeEnum)CompileUtil.castDefault((Object)source.getShape(), (Supplier[])new Supplier[]{() -> (ShapeTypeEnum)p.resolve(Placeholders.property((String)"n2o.api.cell.badge.shape"), ShapeTypeEnum.class)}));
        return cell;
    }
}

