/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.cell;

import java.util.HashMap;
import java.util.function.Supplier;
import net.n2oapp.framework.api.metadata.aware.ActionsAware;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.global.view.widget.table.N2oSwitch;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.N2oBaseColumn;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.cell.N2oAbstractCell;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.cell.N2oActionCell;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.action.Action;
import net.n2oapp.framework.api.metadata.meta.cell.AbstractCell;
import net.n2oapp.framework.api.metadata.meta.cell.ActionCell;
import net.n2oapp.framework.api.script.ScriptProcessor;
import net.n2oapp.framework.config.metadata.compile.BaseSourceCompiler;
import net.n2oapp.framework.config.metadata.compile.ComponentScope;
import net.n2oapp.framework.config.metadata.compile.action.ActionCompileStaticProcessor;
import net.n2oapp.framework.config.util.StylesResolver;

public abstract class AbstractCellCompiler<D extends AbstractCell, S extends N2oAbstractCell>
implements BaseSourceCompiler<D, S, CompileContext<?, ?>> {
    protected D build(D compiled, S source, CompileProcessor p, String defaultSrc) {
        N2oBaseColumn column;
        ComponentScope columnScope = (ComponentScope)p.getScope(ComponentScope.class);
        if (columnScope != null && (column = columnScope.unwrap(N2oBaseColumn.class)) != null) {
            source.setId(column.getId());
            compiled.setId(column.getId());
            compiled.setFieldKey(column.getTextFieldId());
            compiled.setTooltipFieldId(column.getTooltipFieldId());
            if (column.getContentAlignment() != null) {
                compiled.getElementAttributes().put("alignment", column.getContentAlignment().getId());
            }
        }
        compiled.setSrc((String)CompileUtil.castDefault((Object)source.getSrc(), (Supplier[])new Supplier[]{() -> (String)p.resolve(defaultSrc, String.class)}));
        if (source.getCssClass() != null) {
            compiled.getElementAttributes().put("className", p.resolveJS(source.getCssClass()));
        }
        if (source.getStyle() != null) {
            compiled.getElementAttributes().put("style", StylesResolver.resolveStyles(source.getStyle()));
        }
        compiled.setVisible(p.resolveJS(source.getVisible(), Boolean.class));
        compiled.setProperties(p.mapAndResolveAttributes(source));
        return compiled;
    }

    protected void compileAction(ActionCell compiled, N2oActionCell source, CompileContext<?, ?> context, CompileProcessor p) {
        source.setActions(ActionCompileStaticProcessor.initActions((ActionsAware)source, p));
        Action action = ActionCompileStaticProcessor.compileAction((ActionsAware)source, context, p, null, new Object[0]);
        compiled.setAction(action);
    }

    protected String compileSwitch(N2oSwitch n2oSwitch, CompileProcessor p) {
        if (n2oSwitch == null) {
            return null;
        }
        HashMap<Object, String> resolvedCases = new HashMap<Object, String>();
        if (n2oSwitch.getCases() != null) {
            for (String key : n2oSwitch.getCases().keySet()) {
                resolvedCases.put(p.resolve(key), (String)n2oSwitch.getCases().get(key));
            }
        }
        n2oSwitch.setResolvedCases(resolvedCases);
        return ScriptProcessor.buildSwitchExpression((N2oSwitch)n2oSwitch);
    }
}

