/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.application.sidebar;

import java.util.function.Supplier;
import net.n2oapp.framework.api.metadata.N2oAbstractDatasource;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.application.Logo;
import net.n2oapp.framework.api.metadata.application.N2oSidebar;
import net.n2oapp.framework.api.metadata.application.Sidebar;
import net.n2oapp.framework.api.metadata.application.SidebarSideEnum;
import net.n2oapp.framework.api.metadata.application.SidebarStateEnum;
import net.n2oapp.framework.api.metadata.aware.ExtensionAttributesAware;
import net.n2oapp.framework.api.metadata.aware.SourceClassAware;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.global.view.page.datasource.N2oStandardDatasource;
import net.n2oapp.framework.api.metadata.header.SimpleMenu;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.config.metadata.compile.BaseSourceCompiler;
import net.n2oapp.framework.config.metadata.compile.ComponentScope;
import net.n2oapp.framework.config.metadata.compile.context.ApplicationContext;
import net.n2oapp.framework.config.metadata.compile.datasource.DataSourcesScope;
import net.n2oapp.framework.config.util.StylesResolver;
import org.springframework.stereotype.Component;

@Component
public class SidebarCompiler
implements BaseSourceCompiler<Sidebar, N2oSidebar, ApplicationContext>,
SourceClassAware {
    public Class<? extends Source> getSourceClass() {
        return N2oSidebar.class;
    }

    public Sidebar compile(N2oSidebar source, ApplicationContext context, CompileProcessor p) {
        Sidebar sidebar = new Sidebar();
        this.initDatasource(sidebar, source, p);
        sidebar.setSrc((String)CompileUtil.castDefault((Object)source.getSrc(), (Supplier[])new Supplier[]{() -> (String)p.resolve(Placeholders.property((String)"n2o.api.sidebar.src"), String.class)}));
        sidebar.setClassName(source.getCssClass());
        sidebar.setStyle(StylesResolver.resolveStyles(source.getStyle()));
        sidebar.setProperties(p.mapAttributes((ExtensionAttributesAware)source));
        sidebar.setLogo(this.initLogo(source, p));
        sidebar.setPath(source.getPath());
        sidebar.setSubtitle(p.resolveJS(source.getSubtitle()));
        ComponentScope componentScope = new ComponentScope(source);
        sidebar.setMenu(source.getMenu() != null ? (SimpleMenu)p.compile((Object)source.getMenu(), (CompileContext)context, new Object[]{componentScope}) : new SimpleMenu());
        sidebar.setExtraMenu(source.getExtraMenu() != null ? (SimpleMenu)p.compile((Object)source.getExtraMenu(), (CompileContext)context, new Object[]{componentScope}) : new SimpleMenu());
        sidebar.setSide((SidebarSideEnum)CompileUtil.castDefault((Object)source.getSide(), (Supplier[])new Supplier[]{() -> (SidebarSideEnum)p.resolve(Placeholders.property((String)"n2o.api.sidebar.side"), SidebarSideEnum.class)}));
        sidebar.setDefaultState((SidebarStateEnum)CompileUtil.castDefault((Object)source.getDefaultState(), (Object)SidebarStateEnum.MAXI, (Object[])new SidebarStateEnum[0]));
        sidebar.setToggledState((SidebarStateEnum)CompileUtil.castDefault((Object)source.getToggledState(), (Object)(SidebarStateEnum.MAXI.equals((Object)sidebar.getDefaultState()) ? SidebarStateEnum.MINI : SidebarStateEnum.MAXI), (Object[])new SidebarStateEnum[0]));
        sidebar.setOverlay((Boolean)CompileUtil.castDefault((Object)source.getOverlay(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)"n2o.api.sidebar.overlay"), Boolean.class)}));
        sidebar.setToggleOnHover((Boolean)CompileUtil.castDefault((Object)source.getToggleOnHover(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)"n2o.api.sidebar.toggle_on_hover"), Boolean.class)}));
        return sidebar;
    }

    private Logo initLogo(N2oSidebar source, CompileProcessor p) {
        Logo logo = new Logo();
        logo.setTitle(p.resolveJS(source.getTitle()));
        logo.setSrc(source.getLogoSrc());
        logo.setHref(source.getHomePageUrl());
        logo.setClassName(source.getLogoClass());
        return logo;
    }

    private void initDatasource(Sidebar compiled, N2oSidebar source, CompileProcessor p) {
        N2oStandardDatasource datasource;
        if (source.getDatasourceId() == null && source.getDatasource() == null) {
            return;
        }
        String datasourceId = source.getDatasourceId();
        if (source.getDatasourceId() == null) {
            datasource = source.getDatasource();
            datasourceId = datasource.getId();
            source.setDatasourceId(datasourceId);
            source.setDatasource(null);
            DataSourcesScope dataSourcesScope = (DataSourcesScope)p.getScope(DataSourcesScope.class);
            if (dataSourcesScope != null) {
                dataSourcesScope.put(datasourceId, datasource);
            }
        } else {
            DataSourcesScope dataSourcesScope = (DataSourcesScope)p.getScope(DataSourcesScope.class);
            datasource = (N2oAbstractDatasource)dataSourcesScope.get(datasourceId);
        }
        datasource.setSize((Integer)p.resolve(Placeholders.property((String)"n2o.api.sidebar.size"), Integer.class));
        compiled.setDatasource(datasourceId);
    }
}

