/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.application;

import net.n2oapp.framework.api.metadata.Compiled;
import net.n2oapp.framework.api.metadata.application.Application;
import net.n2oapp.framework.api.metadata.application.Sidebar;
import net.n2oapp.framework.api.metadata.aware.PropertiesAware;
import net.n2oapp.framework.api.metadata.compile.BindProcessor;
import net.n2oapp.framework.api.metadata.header.Header;
import net.n2oapp.framework.api.metadata.header.MenuItem;
import net.n2oapp.framework.api.metadata.header.SimpleMenu;
import net.n2oapp.framework.api.metadata.meta.badge.Badge;
import net.n2oapp.framework.api.metadata.meta.badge.BadgeUtil;
import net.n2oapp.framework.config.metadata.compile.BaseMetadataBinder;
import net.n2oapp.framework.config.util.BindUtil;
import org.springframework.stereotype.Component;

@Component
public class ApplicationBinder
implements BaseMetadataBinder<Application> {
    public Class<? extends Compiled> getCompiledClass() {
        return Application.class;
    }

    public Application bind(Application compiled, BindProcessor p) {
        this.bindHeader(p, compiled.getHeader());
        if (compiled.getSidebars() != null) {
            for (Sidebar sidebar : compiled.getSidebars()) {
                this.bindSidebar(p, sidebar);
            }
        }
        if (compiled.getDatasources() != null) {
            compiled.getDatasources().values().forEach(x$0 -> p.bind(x$0, new Object[0]));
        }
        return compiled;
    }

    private void bindHeader(BindProcessor p, Header header) {
        if (header != null) {
            this.bindMenu(header.getMenu(), p);
            this.bindMenu(header.getExtraMenu(), p);
            BindUtil.resolveExtension((PropertiesAware)header, p);
        }
    }

    private void bindSidebar(BindProcessor p, Sidebar sidebar) {
        if (sidebar != null) {
            this.bindMenu(sidebar.getMenu(), p);
            this.bindMenu(sidebar.getExtraMenu(), p);
            sidebar.setSubtitle(p.resolveText(sidebar.getSubtitle()));
            BindUtil.resolveExtension((PropertiesAware)sidebar, p);
        }
    }

    private void bindMenu(SimpleMenu menu, BindProcessor p) {
        if (menu != null && menu.getItems() != null) {
            menu.getItems().forEach(i -> this.resolveItem((MenuItem)i, p));
        }
    }

    private void resolveItem(MenuItem item, BindProcessor p) {
        item.setTitle(p.resolveText(item.getTitle()));
        item.setImageSrc((String)p.resolve(item.getImageSrc(), String.class));
        BindUtil.resolveExtension((PropertiesAware)item, p);
        BadgeUtil.bindSimpleBadge((Badge)item.getBadge(), (BindProcessor)p);
        if (item.getSubItems() != null) {
            item.getSubItems().forEach(i -> this.resolveItem((MenuItem)i, p));
        }
    }
}

