/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.action;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.ReduxModelEnum;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.action.N2oSwitchAction;
import net.n2oapp.framework.api.metadata.aware.ActionsAware;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.action.Action;
import net.n2oapp.framework.api.metadata.meta.action.switchaction.SwitchAction;
import net.n2oapp.framework.api.metadata.meta.action.switchaction.SwitchActionPayload;
import net.n2oapp.framework.config.metadata.compile.PageIndexScope;
import net.n2oapp.framework.config.metadata.compile.action.AbstractActionCompiler;
import net.n2oapp.framework.config.metadata.compile.action.ActionCompileStaticProcessor;
import net.n2oapp.framework.config.util.DatasourceUtil;
import org.springframework.stereotype.Component;

@Component
public class SwitchActionCompiler
extends AbstractActionCompiler<SwitchAction, N2oSwitchAction> {
    public Class<? extends Source> getSourceClass() {
        return N2oSwitchAction.class;
    }

    public SwitchAction compile(N2oSwitchAction source, CompileContext<?, ?> context, CompileProcessor p) {
        this.initDefaults(source, p);
        SwitchAction switchAction = new SwitchAction();
        switchAction.setType((String)p.resolve(Placeholders.property((String)"n2o.api.action.switch.type"), String.class));
        this.compilePayload(source, (SwitchActionPayload)switchAction.getPayload(), context, p);
        this.compileAction(switchAction, source, p);
        return switchAction;
    }

    private void compilePayload(N2oSwitchAction source, SwitchActionPayload payload, CompileContext<?, ?> context, CompileProcessor p) {
        payload.setValueFieldId(source.getValueFieldId());
        this.initDatasource(payload, source.getDatasourceId(), p);
        payload.setModel((ReduxModelEnum)CompileUtil.castDefault((Object)source.getModel(), (Supplier[])new Supplier[]{() -> this.getLocalModel(p)}));
        PageIndexScope indexScope = (PageIndexScope)p.getScope(PageIndexScope.class);
        int switchIndex = indexScope.get();
        payload.setCases(this.mapCases(source, context, p, indexScope, switchIndex));
        payload.setDefaultCase(this.compileActionCase((N2oSwitchAction.AbstractCase)source.getDefaultCase(), context, p, indexScope, switchIndex));
    }

    private Map<String, Action> mapCases(N2oSwitchAction source, CompileContext<?, ?> context, CompileProcessor p, PageIndexScope indexScope, int switchIndex) {
        List valueCases = source.getValueCases();
        HashMap<String, Action> cases = new HashMap<String, Action>();
        for (N2oSwitchAction.Case valueCase : valueCases) {
            cases.put(valueCase.getValue(), this.compileActionCase((N2oSwitchAction.AbstractCase)valueCase, context, p, indexScope, switchIndex));
        }
        return cases;
    }

    private Action compileActionCase(N2oSwitchAction.AbstractCase abstractCase, CompileContext<?, ?> context, CompileProcessor p, PageIndexScope indexScope, int switchIndex) {
        if (abstractCase == null) {
            return null;
        }
        this.initCaseId(abstractCase, switchIndex);
        abstractCase.setActions(ActionCompileStaticProcessor.initActions((ActionsAware)abstractCase, p));
        return ActionCompileStaticProcessor.compileAction((ActionsAware)abstractCase, context, p, null, indexScope);
    }

    private void initCaseId(N2oSwitchAction.AbstractCase abstractCase, int switchIndex) {
        Object caseId;
        if (abstractCase instanceof N2oSwitchAction.Case) {
            N2oSwitchAction.Case switchActionCase = (N2oSwitchAction.Case)abstractCase;
            caseId = switchActionCase.getValue() + "_case";
        } else {
            caseId = "default_case_";
        }
        abstractCase.setId((String)caseId + switchIndex);
    }

    private void initDatasource(SwitchActionPayload payload, String datasourceId, CompileProcessor p) {
        payload.setDatasource(DatasourceUtil.getClientDatasourceId((String)CompileUtil.castDefault((Object)datasourceId, (Supplier[])new Supplier[]{() -> this.getLocalDatasourceId(p)}), p));
        if (payload.getDatasource() == null) {
            throw new N2oException(String.format("\u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445 \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d \u0434\u043b\u044f \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \"<switch>\" \u0441 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u043e\u043c 'value-field-id = %s'", payload.getValueFieldId()));
        }
    }
}

