/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.action;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.action.N2oMultiAction;
import net.n2oapp.framework.api.metadata.action.N2oOnFailAction;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.meta.action.Action;
import net.n2oapp.framework.api.metadata.meta.action.multi.MultiAction;
import net.n2oapp.framework.api.metadata.meta.action.multi.MultiActionPayload;
import net.n2oapp.framework.config.metadata.compile.action.AbstractActionCompiler;
import net.n2oapp.framework.config.metadata.compile.action.ActionCompileStaticProcessor;
import org.springframework.stereotype.Component;

@Component
public class MultiActionCompiler
extends AbstractActionCompiler<MultiAction, N2oMultiAction> {
    public Class<? extends Source> getSourceClass() {
        return N2oMultiAction.class;
    }

    public MultiAction compile(N2oMultiAction source, CompileContext<?, ?> context, CompileProcessor p) {
        List<Action> actions = Arrays.stream(source.getN2oActions()).filter(a -> ActionCompileStaticProcessor.isNotFailConditions(a) && !(a instanceof N2oOnFailAction)).map(n2oAction -> (Action)p.compile(n2oAction, context, new Object[]{ActionCompileStaticProcessor.initFailConditionBranchesScope(n2oAction, source.getN2oActions())})).toList();
        MultiAction multiAction = new MultiAction(actions);
        multiAction.setType((String)p.resolve(Placeholders.property((String)"n2o.api.action.multi.type"), String.class));
        Optional<N2oOnFailAction> onFailAction = Arrays.stream(source.getN2oActions()).filter(N2oOnFailAction.class::isInstance).map(N2oOnFailAction.class::cast).findFirst();
        if (onFailAction.isPresent()) {
            if (onFailAction.get().getActions().length > 1) {
                N2oMultiAction multi = new N2oMultiAction();
                multi.setN2oActions(onFailAction.get().getActions());
                ((MultiActionPayload)multiAction.getPayload()).setFallback((Action)p.compile((Object)multi, context, new Object[0]));
            } else {
                ((MultiActionPayload)multiAction.getPayload()).setFallback((Action)p.compile((Object)onFailAction.get().getActions()[0], context, new Object[0]));
            }
        }
        return multiAction;
    }
}

