/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.action;

import java.util.Map;
import java.util.function.Supplier;
import net.n2oapp.framework.api.metadata.ReduxModelEnum;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.action.N2oCopyAction;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.control.PageRefEnum;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.CopyModeEnum;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.action.copy.CopyAction;
import net.n2oapp.framework.api.metadata.meta.action.copy.CopyActionPayload;
import net.n2oapp.framework.api.metadata.meta.saga.MetaSaga;
import net.n2oapp.framework.config.metadata.compile.action.AbstractActionCompiler;
import net.n2oapp.framework.config.metadata.compile.context.PageContext;
import net.n2oapp.framework.config.util.DatasourceUtil;
import org.springframework.stereotype.Component;

@Component
public class CopyActionCompiler
extends AbstractActionCompiler<CopyAction, N2oCopyAction> {
    public Class<? extends Source> getSourceClass() {
        return N2oCopyAction.class;
    }

    public CopyAction compile(N2oCopyAction source, CompileContext<?, ?> context, CompileProcessor p) {
        this.initDefaults(source, p);
        CopyAction copyAction = new CopyAction();
        this.compileAction(copyAction, source, p);
        copyAction.setType((String)p.resolve(Placeholders.property((String)"n2o.api.action.copy.type"), String.class));
        copyAction.setValidate((Boolean)CompileUtil.castDefault((Object)source.getValidate(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)"n2o.api.action.copy.validate"), Boolean.class)}));
        CopyActionPayload.ClientModel sourceModel = new CopyActionPayload.ClientModel(DatasourceUtil.getClientDatasourceId(source.getSourceDatasourceId(), p), source.getSourceModel().getId(), source.getSourceFieldId());
        CopyActionPayload.ClientModel targetModel = new CopyActionPayload.ClientModel(this.getClientTargetDatasourceId(source, context, p), source.getTargetModel().getId(), source.getTargetFieldId());
        ((CopyActionPayload)copyAction.getPayload()).setSource(sourceModel);
        ((CopyActionPayload)copyAction.getPayload()).setTarget(targetModel);
        ((CopyActionPayload)copyAction.getPayload()).setMode(source.getMode());
        copyAction.setMeta(this.compileMeta(source, p));
        return copyAction;
    }

    @Override
    protected void initDefaults(N2oCopyAction source, CompileProcessor p) {
        super.initDefaults(source, p);
        source.setMode((CopyModeEnum)CompileUtil.castDefault((Object)source.getMode(), (Object)CopyModeEnum.MERGE, (Object[])new CopyModeEnum[0]));
        source.setSourceDatasourceId((String)CompileUtil.castDefault((Object)source.getSourceDatasourceId(), (Supplier[])new Supplier[]{() -> this.getLocalDatasourceId(p)}));
        source.setSourceModel((ReduxModelEnum)CompileUtil.castDefault((Object)source.getSourceModel(), (Object)ReduxModelEnum.RESOLVE, (Object[])new ReduxModelEnum[0]));
        source.setTargetDatasourceId((String)CompileUtil.castDefault((Object)source.getTargetDatasourceId(), (Object)source.getSourceDatasourceId(), (Object[])new String[0]));
        source.setTargetModel((ReduxModelEnum)CompileUtil.castDefault((Object)source.getTargetModel(), (Object)ReduxModelEnum.RESOLVE, (Object[])new ReduxModelEnum[0]));
    }

    private MetaSaga compileMeta(N2oCopyAction source, CompileProcessor p) {
        MetaSaga meta = new MetaSaga();
        boolean closeOnSuccess = (Boolean)CompileUtil.castDefault((Object)source.getCloseOnSuccess(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)"n2o.api.action.copy.close_on_success"), Boolean.class)});
        meta.setModalsToClose(Integer.valueOf(closeOnSuccess ? 1 : 0));
        return meta;
    }

    private String getClientTargetDatasourceId(N2oCopyAction source, CompileContext<?, ?> context, CompileProcessor p) {
        if (source.getTargetPage() == PageRefEnum.PARENT && context instanceof PageContext) {
            PageContext pageContext = (PageContext)context;
            Map<String, String> parentDatasourceIdsMap = pageContext.getParentDatasourceIdsMap();
            if (parentDatasourceIdsMap != null && parentDatasourceIdsMap.containsKey(source.getTargetDatasourceId())) {
                return parentDatasourceIdsMap.get(source.getTargetDatasourceId());
            }
            return DatasourceUtil.getClientDatasourceId(source.getTargetDatasourceId(), pageContext.getParentClientPageId());
        }
        return DatasourceUtil.getClientDatasourceId(source.getTargetDatasourceId(), p);
    }
}

