/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.action;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.ReduxModelEnum;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.action.N2oAnchor;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.global.view.action.control.TargetEnum;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.ModelLink;
import net.n2oapp.framework.api.metadata.meta.action.LinkAction;
import net.n2oapp.framework.api.metadata.meta.action.link.LinkActionImpl;
import net.n2oapp.framework.api.metadata.meta.action.link.LinkActionPayload;
import net.n2oapp.framework.config.metadata.compile.ParentRouteScope;
import net.n2oapp.framework.config.metadata.compile.action.AbstractActionCompiler;
import net.n2oapp.framework.config.register.route.RouteUtil;
import net.n2oapp.framework.config.util.DatasourceUtil;
import org.springframework.stereotype.Component;

@Component
public class AnchorCompiler
extends AbstractActionCompiler<LinkAction, N2oAnchor> {
    public Class<? extends Source> getSourceClass() {
        return N2oAnchor.class;
    }

    public LinkAction compile(N2oAnchor source, CompileContext<?, ?> context, CompileProcessor p) {
        this.initDefaults(source, p);
        LinkActionImpl linkAction = new LinkActionImpl();
        source.setSrc((String)CompileUtil.castDefault((Object)source.getSrc(), (Supplier[])new Supplier[]{() -> (String)p.resolve(Placeholders.property((String)"n2o.api.action.link.src"), String.class)}));
        linkAction.setType((String)p.resolve(Placeholders.property((String)"n2o.api.action.link.type"), String.class));
        this.compileAction(linkAction, source, p);
        ParentRouteScope routeScope = (ParentRouteScope)p.getScope(ParentRouteScope.class);
        String path = source.getHref();
        TargetEnum target = (TargetEnum)CompileUtil.castDefault((Object)source.getTarget(), (Object)TargetEnum.SELF, (Object[])new TargetEnum[0]);
        if (!StringUtils.isLink((Object)source.getHref())) {
            if (TargetEnum.APPLICATION.equals((Object)target)) {
                path = RouteUtil.absolute(source.getHref(), routeScope != null ? routeScope.getUrl() : null);
            }
            path = RouteUtil.normalize(path);
        }
        this.initUrl(linkAction, path, source, routeScope, p);
        linkAction.setTarget(target);
        return linkAction;
    }

    private void initUrl(LinkActionImpl linkAction, String path, N2oAnchor source, ParentRouteScope routeScope, CompileProcessor p) {
        String resolvedPath = p.resolveJS(path);
        linkAction.setUrl(resolvedPath);
        if (StringUtils.isJs((Object)resolvedPath)) {
            String datasourceId = (String)CompileUtil.castDefault((Object)source.getDatasourceId(), (Supplier[])new Supplier[]{() -> this.getLocalDatasourceId(p)});
            ReduxModelEnum reduxModel = (ReduxModelEnum)CompileUtil.castDefault((Object)source.getModel(), (Supplier[])new Supplier[]{() -> this.getLocalModel(p)});
            if (datasourceId == null) {
                throw new N2oException("\u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0434\u043b\u044f \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \"<a>\" \u0441\u043e \u0441\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u043c 'href' " + source.getHref());
            }
            ((LinkActionPayload)linkAction.getPayload()).setModelLink(new ModelLink(reduxModel, DatasourceUtil.getClientDatasourceId(datasourceId, p)).getLink());
        } else {
            this.initMappings((LinkAction)linkAction, source, p, routeScope);
        }
    }

    private void initMappings(LinkAction compiled, N2oAnchor source, CompileProcessor p, ParentRouteScope routeScope) {
        Map<String, ModelLink> pathMapping = this.initParentRoutePathMappings(routeScope, compiled.getUrl());
        LinkedHashMap<String, ModelLink> queryMapping = new LinkedHashMap<String, ModelLink>();
        this.initMappings(source.getPathParams(), source.getQueryParams(), pathMapping, queryMapping, p);
        compiled.setQueryMapping(queryMapping);
        compiled.setPathMapping(pathMapping);
    }
}

