/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.n2oapp.framework.api.metadata.action.N2oAbstractPageAction;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.meta.ModelLink;
import net.n2oapp.framework.api.metadata.meta.action.modal.AbstractModal;
import net.n2oapp.framework.api.metadata.meta.action.modal.ModalPayload;
import net.n2oapp.framework.api.metadata.meta.saga.CloseSaga;
import net.n2oapp.framework.api.metadata.meta.saga.MetaSaga;
import net.n2oapp.framework.api.metadata.meta.saga.RefreshSaga;
import net.n2oapp.framework.config.metadata.compile.action.AbstractOpenPageCompiler;
import net.n2oapp.framework.config.metadata.compile.context.ModalPageContext;
import net.n2oapp.framework.config.metadata.compile.context.PageContext;
import net.n2oapp.framework.config.register.route.RouteUtil;
import net.n2oapp.framework.config.util.DatasourceUtil;

public abstract class AbstractModalCompiler<D extends AbstractModal<? extends ModalPayload>, S extends N2oAbstractPageAction>
extends AbstractOpenPageCompiler<D, S> {
    public void compileModal(S source, D compiled, CompileContext<?, ?> context, CompileProcessor p) {
        compiled.setObjectId(source.getObjectId());
        compiled.setOperationId(source.getOperationId());
        compiled.setPageId(source.getPageId());
        this.compileAction(compiled, source, p);
        PageContext pageContext = this.initPageContext(compiled, source, context, p);
        this.initOnCloseMeta(source, compiled, p);
        this.compilePayload(source, compiled, pageContext, p);
    }

    @Override
    protected ModalPageContext constructContext(S source, String route, CompileProcessor p) {
        ModalPageContext pageContext = new ModalPageContext(source.getPageId(), route);
        this.initToolbarBySubmitOperation(source, pageContext, p);
        pageContext.setClientPageId(RouteUtil.convertPathToId(route));
        return pageContext;
    }

    protected abstract void compilePayload(S var1, D var2, PageContext var3, CompileProcessor var4);

    @Override
    protected void initPageRoute(D compiled, String route, Map<String, ModelLink> pathMapping, Map<String, ModelLink> queryMapping) {
        ModalPayload payload = (ModalPayload)compiled.getPayload();
        String modalPageId = RouteUtil.convertPathToId(route);
        payload.setName(modalPageId);
        payload.setPageId(modalPageId);
        payload.setPageUrl(route);
        payload.setPathMapping(pathMapping);
        payload.setQueryMapping(queryMapping);
    }

    private void initOnCloseMeta(S source, D compiled, CompileProcessor p) {
        if (!Boolean.TRUE.equals(source.getRefreshOnClose())) {
            return;
        }
        if (compiled.getMeta() == null) {
            compiled.setMeta(new MetaSaga());
        }
        compiled.getMeta().setOnClose(new CloseSaga());
        RefreshSaga refreshSaga = new RefreshSaga();
        ArrayList<String> refreshDsIds = new ArrayList<String>();
        if (source.getRefreshDatasourceIds() == null) {
            String[] datasourceIds = this.getRefreshDatasourceId(source, p);
            if (datasourceIds != null) {
                refreshDsIds.addAll(List.of(datasourceIds));
            }
        } else {
            refreshDsIds.addAll(Arrays.asList(source.getRefreshDatasourceIds()));
        }
        refreshSaga.setDatasources(DatasourceUtil.getClientDatasourceIds(refreshDsIds, p));
        compiled.getMeta().getOnClose().setRefresh(refreshSaga);
    }
}

