/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.io;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.n2oapp.framework.api.metadata.aware.NamespaceUriAware;
import net.n2oapp.framework.api.metadata.io.NamespaceIO;
import net.n2oapp.framework.api.metadata.io.NamespaceIOFactory;
import net.n2oapp.framework.api.metadata.io.ProxyNamespaceIO;
import net.n2oapp.framework.api.metadata.persister.NamespacePersister;
import net.n2oapp.framework.api.metadata.persister.NamespacePersisterFactory;
import net.n2oapp.framework.api.metadata.reader.NamespaceReader;
import net.n2oapp.framework.api.metadata.reader.NamespaceReaderFactory;
import org.jdom2.Namespace;

public class NamespaceIOFactoryByMap<T extends NamespaceUriAware, R extends NamespaceReader<? extends T>, P extends NamespacePersister<? super T>>
implements NamespaceIOFactory<T, R, P> {
    private Class<T> baseElementClass;
    private Map<String, Map<String, R>> names = new HashMap<String, Map<String, R>>();
    private Map<String, Map<Class, P>> classes = new HashMap<String, Map<Class, P>>();
    private NamespaceReaderFactory readerFactory;
    private NamespacePersisterFactory persisterFactory;
    private Set<String> ignoredElements = new HashSet<String>();

    public NamespaceIOFactoryByMap(Class<T> baseElementClass, NamespaceReaderFactory readerFactory, NamespacePersisterFactory persisterFactory) {
        this.baseElementClass = baseElementClass;
        this.readerFactory = readerFactory;
        this.persisterFactory = persisterFactory;
    }

    public P produce(Class<T> clazz, Namespace ... namespaces) {
        for (Namespace namespace : namespaces) {
            if (!this.classes.containsKey(namespace.getURI()) || !this.classes.get(namespace.getURI()).containsKey(clazz)) continue;
            return (P)((NamespacePersister)this.classes.get(namespace.getURI()).get(clazz));
        }
        return (P)this.persisterFactory.produce(clazz, namespaces);
    }

    public R produce(String elementName, Namespace ... namespaces) {
        if (this.ignoredElements.contains(elementName)) {
            return null;
        }
        for (Namespace namespace : namespaces) {
            if (!this.names.containsKey(namespace.getURI()) || !this.names.get(namespace.getURI()).containsKey(elementName)) continue;
            return (R)((NamespaceReader)this.names.get(namespace.getURI()).get(elementName));
        }
        return (R)this.readerFactory.produce(elementName, namespaces);
    }

    public NamespaceIOFactory<T, R, P> add(NamespaceIO<? extends T> nio) {
        ProxyNamespaceIO proxy = new ProxyNamespaceIO(nio);
        this.names.computeIfAbsent(nio.getNamespaceUri(), k -> new HashMap()).put(nio.getElementName(), proxy);
        this.classes.computeIfAbsent(nio.getNamespaceUri(), k -> new HashMap()).put(nio.getElementClass(), proxy);
        return this;
    }

    public NamespaceIOFactory<T, R, P> ignore(String ... elementNames) {
        if (elementNames != null) {
            Collections.addAll(this.ignoredElements, elementNames);
        }
        return this;
    }

    public void add(NamespacePersister<T> persister) {
        this.classes.computeIfAbsent(persister.getNamespaceUri(), k -> new HashMap()).put(persister.getElementClass(), persister);
    }

    public void add(NamespaceReader<T> reader) {
        this.names.computeIfAbsent(reader.getNamespaceUri(), k -> new HashMap()).put(reader.getElementName(), reader);
    }

    public Class<T> getBaseElementClass() {
        return this.baseElementClass;
    }
}

