/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.io;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import lombok.Generated;
import net.n2oapp.framework.api.MetadataEnvironment;
import net.n2oapp.framework.api.N2oNamespace;
import net.n2oapp.framework.api.data.DomainProcessor;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.aware.N2oEnum;
import net.n2oapp.framework.api.metadata.aware.NamespaceUriAware;
import net.n2oapp.framework.api.metadata.aware.RefIdAware;
import net.n2oapp.framework.api.metadata.io.ClassedElementIO;
import net.n2oapp.framework.api.metadata.io.ElementIO;
import net.n2oapp.framework.api.metadata.io.ElementIOFactory;
import net.n2oapp.framework.api.metadata.io.IOProcessor;
import net.n2oapp.framework.api.metadata.io.IOProcessorAware;
import net.n2oapp.framework.api.metadata.io.NamedElementIO;
import net.n2oapp.framework.api.metadata.io.NamespaceIOFactory;
import net.n2oapp.framework.api.metadata.io.TypedElementIO;
import net.n2oapp.framework.api.metadata.persister.NamespacePersister;
import net.n2oapp.framework.api.metadata.persister.NamespacePersisterFactory;
import net.n2oapp.framework.api.metadata.persister.TypedElementPersister;
import net.n2oapp.framework.api.metadata.reader.NamespaceReader;
import net.n2oapp.framework.api.metadata.reader.NamespaceReaderFactory;
import net.n2oapp.framework.api.metadata.reader.TypedElementReader;
import net.n2oapp.framework.config.io.ElementIOFactoryByMap;
import net.n2oapp.framework.config.io.MetadataParamHolder;
import net.n2oapp.framework.config.io.NamespaceIOFactoryByMap;
import net.n2oapp.framework.config.metadata.merge.MergeUtil;
import org.apache.commons.lang3.ArrayUtils;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.core.env.PropertyResolver;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class IOProcessorImpl
implements IOProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IOProcessorImpl.class);
    private final boolean r;
    private NamespaceReaderFactory readerFactory;
    private NamespacePersisterFactory persisterFactory;
    private MessageSourceAccessor messageSourceAccessor;
    private PropertyResolver systemProperties;
    private boolean failFast = true;
    private final DomainProcessor domainProcessor = new DomainProcessor();
    private static final String EXCEPTION_MESSAGE = "you should first call #newInstance(Element)";
    private static final Pattern XML_ESCAPE_SYMBOLS = Pattern.compile("[&<>'\"]");
    private MetadataEnvironment environment;

    public IOProcessorImpl(boolean read) {
        this.r = read;
    }

    public IOProcessorImpl(NamespaceReaderFactory readerFactory, MetadataEnvironment environment) {
        this.r = true;
        this.environment = environment;
        this.readerFactory = readerFactory;
        if (readerFactory instanceof IOProcessorAware) {
            IOProcessorAware ioProcessorAware = (IOProcessorAware)readerFactory;
            ioProcessorAware.setIOProcessor((IOProcessor)this);
        }
    }

    public IOProcessorImpl(NamespacePersisterFactory persisterFactory, MetadataEnvironment environment) {
        this(persisterFactory);
        this.environment = environment;
    }

    public IOProcessorImpl(NamespacePersisterFactory persisterFactory) {
        this.r = false;
        this.persisterFactory = persisterFactory;
        if (persisterFactory instanceof IOProcessorAware) {
            IOProcessorAware ioProcessorAware = (IOProcessorAware)persisterFactory;
            ioProcessorAware.setIOProcessor((IOProcessor)this);
        }
    }

    public <T> void read(Element element, T entity, BiConsumer<Element, T> reader) {
        if (this.r) {
            reader.accept(element, (Element)entity);
        }
    }

    public <T> void persist(T entity, Element element, BiConsumer<T, Element> persister) {
        if (!this.r) {
            persister.accept(entity, element);
        }
    }

    public <T> void child(Element element, String sequences, String childName, Supplier<? extends T> getter, Consumer<? super T> setter, TypedElementIO<T> io) {
        if (this.r) {
            Element child;
            if (sequences != null) {
                child = element.getChild(sequences, element.getNamespace());
                if (child == null) {
                    return;
                }
            } else {
                child = element;
            }
            if ((child = child.getChild(childName, element.getNamespace())) != null) {
                setter.accept(this.read((ClassedElementIO<T>)io, child));
            }
        } else {
            T entity = getter.get();
            if (entity != null) {
                Element seqE = element;
                if (sequences != null) {
                    seqE = this.initSequenceElement(element, sequences);
                }
                Element childE = this.persist((NamedElementIO<T>)io, entity, element.getNamespace());
                this.installNamespace(childE, element.getNamespace());
                seqE.addContent((Content)childE);
            }
        }
    }

    public <T> void child(Element element, String sequences, final String childName, Supplier<T> getter, Consumer<T> setter, final Class<T> elementClass, final ElementIO<T> io) {
        this.child(element, sequences, childName, getter, setter, new TypedElementIO<T>(this){

            public Class<T> getElementClass() {
                return elementClass;
            }

            public void io(Element e, T t, IOProcessor p) {
                io.io(e, t, p);
            }

            public String getElementName() {
                return childName;
            }
        });
    }

    public <T> void child(Element element, String sequences, final String childName, Supplier<? extends T> getter, Consumer<? super T> setter, final Supplier<? extends T> newInstance, final ElementIO<T> io) {
        this.child(element, sequences, childName, getter, setter, new TypedElementIO<T>(){
            private Class<T> elementClass;

            public String getElementName() {
                return childName;
            }

            public Class<T> getElementClass() {
                if (this.elementClass == null) {
                    throw new IllegalStateException(IOProcessorImpl.EXCEPTION_MESSAGE);
                }
                return this.elementClass;
            }

            public T newInstance(Element element) {
                Object entity = newInstance.get();
                if (this.elementClass == null) {
                    this.elementClass = entity.getClass();
                }
                return entity;
            }

            public void io(Element e, T t, IOProcessor p) {
                io.io(e, t, p);
            }
        });
    }

    public <T, R extends TypedElementReader<? extends T>, P extends TypedElementPersister<? super T>> void anyChild(Element element, String sequences, Supplier<? extends T> getter, Consumer<? super T> setter, ElementIOFactory<T, R, P> factory) {
        if (this.r) {
            Element seqE;
            if (sequences != null) {
                seqE = element.getChild(sequences, element.getNamespace());
                if (seqE == null) {
                    return;
                }
            } else {
                seqE = element;
            }
            for (Object child : seqE.getChildren()) {
                Element childE = (Element)child;
                setter.accept(this.read(factory, childE));
            }
        } else {
            T entity = getter.get();
            if (entity == null) {
                return;
            }
            Element seqE = sequences != null ? this.initSequenceElement(element, sequences) : element;
            Element childE = this.persist(factory, entity, element.getNamespace());
            if (childE != null) {
                this.installNamespace(childE, element.getNamespace());
                seqE.addContent((Content)childE);
            }
        }
    }

    public <T extends NamespaceUriAware, R extends NamespaceReader<? extends T>, P extends NamespacePersister<? super T>> void anyChild(Element element, String sequences, Supplier<T> getter, Consumer<T> setter, NamespaceIOFactory<T, R, P> factory, Namespace defaultNamespace) {
        if (this.r) {
            Element seqE;
            if (sequences != null) {
                seqE = element.getChild(sequences, element.getNamespace());
                if (seqE == null) {
                    return;
                }
            } else {
                seqE = element;
            }
            for (Object child : seqE.getChildren()) {
                Element childE = (Element)child;
                T childT = this.read(factory, childE, seqE.getNamespace(), defaultNamespace);
                if (childT == null) continue;
                setter.accept(childT);
                return;
            }
        } else {
            NamespaceUriAware entity = (NamespaceUriAware)getter.get();
            if (entity == null) {
                return;
            }
            Element seqE = sequences != null ? this.initSequenceElement(element, sequences) : element;
            Element childE = this.persist(factory, entity, seqE.getNamespace(), defaultNamespace);
            if (childE != null) {
                this.installNamespace(childE, element.getNamespace());
                seqE.addContent((Content)childE);
            }
        }
    }

    public <T> void children(Element element, String sequences, String childrenName, Supplier<T[]> getter, Consumer<T[]> setter, TypedElementIO<T> io) {
        if (this.r) {
            Element seqE;
            ArrayList<T> result = new ArrayList<T>();
            if (sequences != null) {
                seqE = element.getChild(sequences, element.getNamespace());
                if (seqE == null) {
                    return;
                }
            } else {
                seqE = element;
            }
            for (Object child : seqE.getChildren(childrenName, seqE.getNamespace())) {
                Element childE = (Element)child;
                T entity = this.read((ClassedElementIO<T>)io, childE);
                result.add(entity);
            }
            if (!result.isEmpty()) {
                Object[] res = (Object[])Array.newInstance(io.getElementClass(), result.size());
                res = result.toArray(res);
                setter.accept(res);
            }
        } else {
            T[] entity = getter.get();
            if (entity == null) {
                return;
            }
            Element seqE = sequences != null ? this.initSequenceElement(element, sequences) : element;
            for (T child : entity) {
                Element childE = this.persist((NamedElementIO<T>)io, child, seqE.getNamespace());
                this.installNamespace(childE, seqE.getNamespace());
                seqE.addContent((Content)childE);
            }
        }
    }

    public void childrenToMap(Element element, String sequences, String childrenName, String keyName, String valueName, Supplier<Map<String, Object>> getter, Consumer<Map<String, Object>> setter) {
        if (this.r) {
            Element seqE;
            HashMap<String, Object> result = new HashMap<String, Object>();
            if (sequences != null) {
                seqE = element.getChild(sequences, element.getNamespace());
                if (seqE == null) {
                    return;
                }
            } else {
                seqE = element;
            }
            for (Object child : seqE.getChildren(childrenName, seqE.getNamespace())) {
                Element childE = (Element)child;
                String key = this.process(childE.getAttribute(keyName).getValue());
                String value = valueName == null ? childE.getValue() : childE.getAttribute(valueName).getValue();
                Object objValue = this.domainProcessor.deserialize((Object)value, (String)null);
                result.put(key, objValue);
            }
            setter.accept(result);
        } else {
            this.persistChildrenMap(element, sequences, childrenName, keyName, valueName, getter);
        }
    }

    public void childrenAttributesToMap(Element element, String sequences, String childrenName, Supplier<Map<String, Object>> getter, Consumer<Map<String, Object>> setter) {
        if (this.r) {
            Element seqE;
            HashMap<String, Object> result = new HashMap<String, Object>();
            if (sequences != null) {
                seqE = element.getChild(sequences, element.getNamespace());
                if (seqE == null) {
                    return;
                }
            } else {
                seqE = element;
            }
            for (Object child : seqE.getChildren(childrenName, seqE.getNamespace())) {
                Element childE = (Element)child;
                Attribute attribute = (Attribute)childE.getAttributes().get(0);
                String key = attribute.getName();
                String value = attribute.getValue();
                Object objValue = this.domainProcessor.deserialize((Object)value);
                result.put(key, objValue);
            }
            setter.accept(result);
        } else {
            Map<String, Object> values = getter.get();
            if (values == null) {
                return;
            }
            Element seqE = this.persistSequences(element, sequences);
            for (Map.Entry<String, Object> entry : values.entrySet()) {
                Element childE = new Element(childrenName, element.getNamespace());
                childE.setAttribute(entry.getKey(), entry.getValue().toString());
                seqE.addContent((Content)childE);
            }
        }
    }

    public void childrenToStringMap(Element element, String sequences, String childrenName, String keyName, String valueName, Supplier<Map<String, String>> getter, Consumer<Map<String, String>> setter) {
        if (this.r) {
            Element seqE;
            HashMap<String, String> result = new HashMap<String, String>();
            if (sequences != null) {
                seqE = element.getChild(sequences, element.getNamespace());
                if (seqE == null) {
                    return;
                }
            } else {
                seqE = element;
            }
            for (Object child : seqE.getChildren(childrenName, seqE.getNamespace())) {
                Element childE = (Element)child;
                String key = null;
                if (childE.getAttribute(keyName) != null) {
                    key = this.process(childE.getAttribute(keyName).getValue());
                }
                String value = valueName == null ? childE.getValue() : childE.getAttribute(valueName).getValue();
                result.put(key, value);
            }
            setter.accept(result);
        } else {
            this.persistChildrenMap(element, sequences, childrenName, keyName, valueName, getter);
        }
    }

    public void childrenToStringArray(Element element, String sequences, String childrenName, Supplier<String[]> getter, Consumer<String[]> setter) {
        if (this.r) {
            Element seqE;
            ArrayList<String> result = new ArrayList<String>();
            if (sequences != null) {
                seqE = element.getChild(sequences, element.getNamespace());
                if (seqE == null) {
                    return;
                }
            } else {
                seqE = element;
            }
            for (Object child : seqE.getChildren(childrenName, seqE.getNamespace())) {
                Element childE = (Element)child;
                String value = this.process(childE.getValue());
                result.add(value);
            }
            if (!result.isEmpty()) {
                String[] res = new String[result.size()];
                setter.accept(result.toArray(res));
            }
        } else {
            String[] values = getter.get();
            if (values == null) {
                return;
            }
            Element seqE = this.persistSequences(element, sequences);
            for (String k : values) {
                Element childE = new Element(childrenName, element.getNamespace());
                childE.setText(k);
                seqE.addContent((Content)childE);
            }
        }
    }

    private Element persistSequences(Element element, String sequences) {
        Element seqE = sequences != null ? this.initSequenceElement(element, sequences) : element;
        return seqE;
    }

    private <T> void persistChildrenMap(Element element, String sequences, String childrenName, String keyName, String valueName, Supplier<Map<String, T>> getter) {
        Map<String, T> values = getter.get();
        if (values == null) {
            return;
        }
        Element seqE = this.persistSequences(element, sequences);
        for (Map.Entry<String, T> entry : values.entrySet()) {
            Element childE = new Element(childrenName, element.getNamespace());
            childE.setAttribute(keyName, entry.getKey());
            if (valueName == null) {
                childE.setText(entry.getValue().toString());
            } else if (entry.getValue() != null) {
                childE.setAttribute(valueName, entry.getValue().toString());
            }
            seqE.addContent((Content)childE);
        }
    }

    public <T> void children(Element element, String sequences, final String childrenName, Supplier<T[]> getter, Consumer<T[]> setter, final Class<T> elementClass, final ElementIO<T> io) {
        this.children(element, sequences, childrenName, getter, setter, new TypedElementIO<T>(){

            public String getElementName() {
                return childrenName;
            }

            public Class<T> getElementClass() {
                return elementClass;
            }

            public void io(Element e, T t, IOProcessor p) {
                io.io(e, t, p);
            }
        });
    }

    public <T> void children(Element element, String sequences, final String childrenName, Supplier<T[]> getter, Consumer<T[]> setter, final Supplier<T> newInstance, final ElementIO<T> io) {
        this.children(element, sequences, childrenName, getter, setter, new TypedElementIO<T>(){
            private Class<T> elementClass;

            public String getElementName() {
                return childrenName;
            }

            public Class<T> getElementClass() {
                if (this.elementClass == null) {
                    throw new IllegalStateException(IOProcessorImpl.EXCEPTION_MESSAGE);
                }
                return this.elementClass;
            }

            public T newInstance(Element element) {
                Object entity = newInstance.get();
                if (this.elementClass == null) {
                    this.elementClass = entity.getClass();
                }
                return entity;
            }

            public void io(Element e, T t, IOProcessor p) {
                io.io(e, t, p);
            }
        });
    }

    public <T, R extends TypedElementReader<? extends T>, P extends TypedElementPersister<? super T>> void anyChildren(Element element, String sequences, Supplier<T[]> getter, Consumer<T[]> setter, ElementIOFactory<T, R, P> factory) {
        if (this.r) {
            Element seqE;
            if (sequences != null) {
                seqE = element.getChild(sequences, element.getNamespace());
                if (seqE == null) {
                    return;
                }
            } else {
                seqE = element;
            }
            ArrayList<T> result = new ArrayList<T>();
            for (Object child : seqE.getChildren()) {
                Element childE = (Element)child;
                T childT = this.read(factory, childE);
                if (childT == null) continue;
                result.add(childT);
            }
            Object[] res = (Object[])Array.newInstance(factory.getBaseElementClass(), result.size());
            res = result.toArray(res);
            setter.accept(res);
        } else {
            T[] entities = getter.get();
            if (entities == null) {
                return;
            }
            Element seqE = sequences != null ? this.initSequenceElement(element, sequences) : element;
            for (T child : entities) {
                Element childE = this.persist(factory, child, element.getNamespace());
                if (childE == null) continue;
                this.installNamespace(childE, element.getNamespace());
                seqE.addContent((Content)childE);
            }
        }
    }

    public <T extends NamespaceUriAware, R extends NamespaceReader<? extends T>, P extends NamespacePersister<? super T>> void anyChildren(Element element, String sequences, Supplier<T[]> getter, Consumer<T[]> setter, NamespaceIOFactory<T, R, P> factory, Namespace ... defaultNamespace) {
        if (this.r) {
            Element seqE;
            if (sequences != null) {
                seqE = element.getChild(sequences, element.getNamespace());
                if (seqE == null) {
                    return;
                }
            } else {
                seqE = element;
            }
            ArrayList<T> result = new ArrayList<T>();
            for (Object child : seqE.getChildren()) {
                Element childE = (Element)child;
                T childT = this.read(factory, childE, seqE.getNamespace(), defaultNamespace);
                if (childT == null) continue;
                result.add(childT);
            }
            if (!result.isEmpty()) {
                NamespaceUriAware[] res = factory.getBaseElementClass() == null ? (NamespaceUriAware[])Array.newInstance(NamespaceUriAware.class, result.size()) : (NamespaceUriAware[])Array.newInstance(factory.getBaseElementClass(), result.size());
                res = result.toArray(res);
                setter.accept(res);
            }
        } else {
            NamespaceUriAware[] entities = (NamespaceUriAware[])getter.get();
            if (entities == null) {
                return;
            }
            Element seqE = sequences != null ? this.initSequenceElement(element, sequences) : element;
            for (NamespaceUriAware child : entities) {
                Element childE = this.persist(factory, child, seqE.getNamespace(), defaultNamespace);
                if (childE == null) continue;
                this.installNamespace(childE, element.getNamespace());
                seqE.addContent((Content)childE);
            }
        }
    }

    public <T, E extends Enum<E>> void childrenByEnum(Element element, String sequences, Supplier<T[]> getterList, Consumer<T[]> setterList, Class<E> enumClass, Function<T, E> getterEnum, BiConsumer<T, E> setterEnum, final ClassedElementIO<T> io) {
        if (this.r) {
            Element seqE;
            ArrayList<T> result = new ArrayList<T>();
            if (sequences != null) {
                seqE = element.getChild(sequences, element.getNamespace());
                if (seqE == null) {
                    return;
                }
            } else {
                seqE = element;
            }
            for (Object child : seqE.getChildren()) {
                Element childE = (Element)child;
                E en = IOProcessorImpl.stringToEnum(childE.getName(), enumClass);
                if (en == null) continue;
                T entity = this.read(io, childE);
                setterEnum.accept(entity, en);
                result.add(entity);
            }
            if (!result.isEmpty()) {
                Object[] res = (Object[])Array.newInstance(io.getElementClass(), result.size());
                res = result.toArray(res);
                setterList.accept(res);
            }
        } else {
            T[] entity = getterList.get();
            if (entity == null || entity.length == 0) {
                return;
            }
            Element seqE = sequences != null ? this.initSequenceElement(element, sequences) : element;
            for (T child : entity) {
                final Enum en = (Enum)getterEnum.apply(child);
                Element childE = null;
                if (en == null) continue;
                childE = this.persist(new NamedElementIO<T>(){

                    public String getElementName() {
                        if (en instanceof N2oEnum) {
                            N2oEnum n2oEnum = (N2oEnum)en;
                            return n2oEnum.getId();
                        }
                        return en.name();
                    }

                    public void io(Element e, T t, IOProcessor p) {
                        io.io(e, t, p);
                    }
                }, child, seqE.getNamespace());
                this.installNamespace(childE, element.getNamespace());
                seqE.addContent((Content)childE);
            }
        }
    }

    public <T, E extends Enum<E>> void childrenByEnum(Element element, String sequences, Supplier<T[]> getterList, Consumer<T[]> setterList, Function<T, E> getterEnum, BiConsumer<T, E> setterEnum, final Supplier<T> newInstance, Class<E> enumClass, final ElementIO<T> io) {
        this.childrenByEnum(element, sequences, getterList, setterList, enumClass, getterEnum, setterEnum, new ClassedElementIO<T>(){
            private Class<T> elementClass;

            public Class<T> getElementClass() {
                if (this.elementClass == null) {
                    throw new IllegalStateException(IOProcessorImpl.EXCEPTION_MESSAGE);
                }
                return this.elementClass;
            }

            public T newInstance(Element element) {
                Object entity = newInstance.get();
                if (this.elementClass == null) {
                    this.elementClass = entity.getClass();
                }
                return entity;
            }

            public void io(Element e, T t, IOProcessor p) {
                io.io(e, t, p);
            }
        });
    }

    public void attribute(Element element, String name, Supplier<String> getter, Consumer<String> setter) {
        if (this.r) {
            Attribute attribute = element.getAttribute(name);
            if (attribute != null) {
                setter.accept(this.process(attribute.getValue()));
            }
        } else {
            if (getter.get() == null) {
                return;
            }
            element.setAttribute(new Attribute(name, getter.get()));
        }
    }

    public void text(Element element, Supplier<String> getter, Consumer<String> setter) {
        this.text(element, getter, setter, s -> net.n2oapp.framework.api.StringUtils.removeSpaces((String)this.process((String)s)));
    }

    public void childrenText(Element element, String childName, Supplier<String> getter, Consumer<String> setter) {
        this.childrenText(element, childName, getter, setter, s -> net.n2oapp.framework.api.StringUtils.removeSpaces((String)this.process((String)s)));
    }

    public void originalText(Element element, Supplier<String> getter, Consumer<String> setter) {
        this.text(element, getter, setter, this::process);
    }

    public void childrenOriginalText(Element element, String childName, Supplier<String> getter, Consumer<String> setter) {
        this.childrenText(element, childName, getter, setter, this::process);
    }

    public void childAttribute(Element element, String childName, String name, Supplier<String> getter, Consumer<String> setter) {
        if (this.r) {
            Element child = element.getChild(childName, element.getNamespace());
            if (child == null) {
                return;
            }
            Attribute attribute = child.getAttribute(name);
            if (attribute != null) {
                setter.accept(this.process(attribute.getValue()));
            }
        } else {
            if (getter.get() == null) {
                return;
            }
            Element childElement = element.getChild(childName, element.getNamespace());
            if (childElement == null) {
                childElement = new Element(childName, element.getNamespace());
                childElement.setAttribute(new Attribute(name, getter.get()));
                element.addContent((Content)childElement);
            } else {
                childElement.setAttribute(new Attribute(name, getter.get()));
            }
        }
    }

    public void childAttributeBoolean(Element element, String childName, String name, Supplier<Boolean> getter, Consumer<Boolean> setter) {
        if (this.r) {
            Element child = element.getChild(childName, element.getNamespace());
            if (child == null) {
                return;
            }
            Attribute attribute = child.getAttribute(name);
            if (attribute != null) {
                setter.accept(Boolean.valueOf(this.process(attribute.getValue())));
            }
        } else {
            if (getter.get() == null) {
                return;
            }
            Element childElement = element.getChild(childName, element.getNamespace());
            if (childElement == null) {
                childElement = new Element(childName, element.getNamespace());
                childElement.setAttribute(new Attribute(name, getter.get().toString()));
                element.addContent((Content)childElement);
            } else {
                childElement.setAttribute(new Attribute(name, getter.get().toString()));
            }
        }
    }

    public void childAttributeInteger(Element element, String childName, String name, Supplier<Integer> getter, Consumer<Integer> setter) {
        if (this.r) {
            Element child = element.getChild(childName, element.getNamespace());
            if (child == null) {
                return;
            }
            Attribute attribute = child.getAttribute(name);
            if (attribute != null) {
                setter.accept(Integer.parseInt(this.process(attribute.getValue())));
            }
        } else {
            if (getter.get() == null) {
                return;
            }
            Element childElement = element.getChild(childName, element.getNamespace());
            if (childElement == null) {
                childElement = new Element(childName, element.getNamespace());
                childElement.setAttribute(new Attribute(name, getter.get().toString()));
                element.addContent((Content)childElement);
            } else {
                childElement.setAttribute(new Attribute(name, getter.get().toString()));
            }
        }
    }

    public <T extends Enum<T>> void childAttributeEnum(Element element, String childName, String name, Supplier<T> getter, Consumer<T> setter, Class<T> enumClass) {
        if (this.r) {
            Element child = element.getChild(childName, element.getNamespace());
            if (child == null) {
                return;
            }
            Attribute attribute = child.getAttribute(name);
            if (attribute != null) {
                setter.accept(IOProcessorImpl.stringToEnum(this.process(attribute.getValue()), enumClass));
            }
        } else {
            if (getter.get() == null) {
                return;
            }
            Element childElement = element.getChild(childName, element.getNamespace());
            if (childElement == null) {
                childElement = new Element(childName, element.getNamespace());
                element.addContent((Content)childElement);
            }
            if (N2oEnum.class.isAssignableFrom(enumClass)) {
                childElement.setAttribute(new Attribute(name, ((N2oEnum)getter.get()).getId()));
            } else {
                childElement.setAttribute(new Attribute(name, ((Enum)getter.get()).name()));
            }
        }
    }

    public void otherAttributes(Element element, Namespace namespace, Map<String, String> map) {
        if (this.r) {
            for (Object o : element.getAttributes()) {
                Attribute attribute = (Attribute)o;
                if (!attribute.getNamespace().equals((Object)namespace)) continue;
                if (attribute.getValue() instanceof String) {
                    map.put(attribute.getName(), this.process(attribute.getValue()));
                    continue;
                }
                map.put(attribute.getName(), attribute.getValue());
            }
        } else {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                element.setAttribute(new Attribute(entry.getKey(), entry.getValue(), namespace));
            }
        }
    }

    public void childAnyAttributes(Element element, String childName, Supplier<Map<N2oNamespace, Map<String, String>>> getter, Consumer<Map<N2oNamespace, Map<String, String>>> setter) {
        if (this.r) {
            Element child = element.getChild(childName, element.getNamespace());
            if (child == null) {
                return;
            }
            this.anyAttributes(child, getter, setter);
        } else {
            if (getter.get() == null) {
                return;
            }
            Element childElement = element.getChild(childName, element.getNamespace());
            if (childElement == null) {
                childElement = new Element(childName, element.getNamespace());
                this.anyAttributes(childElement, getter, setter);
                element.addContent((Content)childElement);
            } else {
                this.anyAttributes(childElement, getter, setter);
            }
        }
    }

    public void anyAttributes(Element element, Supplier<Map<N2oNamespace, Map<String, String>>> getter, Consumer<Map<N2oNamespace, Map<String, String>>> setter) {
        if (this.r) {
            N2oNamespace elementNamespace = new N2oNamespace(element.getNamespace());
            HashMap extensions = new HashMap();
            for (Attribute attribute : element.getAttributes()) {
                if (attribute.getNamespaceURI().isEmpty() || elementNamespace.getUri().equals(attribute.getNamespaceURI())) continue;
                N2oNamespace namespace = new N2oNamespace(attribute.getNamespace());
                extensions.putIfAbsent(namespace, new HashMap());
                ((Map)extensions.get(namespace)).put(attribute.getName(), this.process(attribute.getValue()));
            }
            setter.accept(extensions);
        } else {
            Map<N2oNamespace, Map<String, String>> extensions = getter.get();
            if (extensions == null) {
                return;
            }
            for (Map.Entry<N2oNamespace, Map<String, String>> map : extensions.entrySet()) {
                for (Map.Entry<String, String> entry : map.getValue().entrySet()) {
                    element.setAttribute(new Attribute(entry.getKey(), entry.getValue(), Namespace.getNamespace((String)map.getKey().getPrefix(), (String)map.getKey().getUri())));
                }
            }
        }
    }

    public void attributeBoolean(Element element, String name, Supplier<Boolean> getter, Consumer<Boolean> setter) {
        if (this.r) {
            Attribute attribute = element.getAttribute(name);
            if (attribute != null) {
                setter.accept(Boolean.valueOf(this.process(attribute.getValue())));
            }
        } else {
            if (getter.get() == null) {
                return;
            }
            element.setAttribute(new Attribute(name, getter.get().toString()));
        }
    }

    public void attributeInteger(Element element, String name, Supplier<Integer> getter, Consumer<Integer> setter) {
        if (this.r) {
            Attribute attribute = element.getAttribute(name);
            if (attribute != null) {
                setter.accept(Integer.parseInt(this.process(attribute.getValue())));
            }
        } else {
            if (getter.get() == null) {
                return;
            }
            element.setAttribute(new Attribute(name, getter.get().toString()));
        }
    }

    public void attributeArray(Element element, String name, String separator, Supplier<String[]> getter, Consumer<String[]> setter) {
        if (this.r) {
            Attribute attribute = element.getAttribute(name);
            if (attribute != null) {
                String value = this.process(attribute.getValue());
                if (value != null) {
                    setter.accept(value.trim().split("\\s*" + separator + "\\s*"));
                } else {
                    setter.accept(null);
                }
            }
        } else {
            if (getter.get() == null) {
                return;
            }
            StringJoiner str = new StringJoiner(",");
            for (String s : getter.get()) {
                str.add(s);
            }
            element.setAttribute(new Attribute(name, str.toString()));
        }
    }

    public <T extends Enum<T>> void attributeEnum(Element element, String name, Supplier<T> getter, Consumer<T> setter, Class<T> enumClass) {
        if (this.r) {
            Attribute attribute = element.getAttribute(name);
            if (attribute != null) {
                setter.accept(IOProcessorImpl.stringToEnum(this.process(attribute.getValue()), enumClass));
            }
        } else {
            if (getter.get() == null) {
                return;
            }
            if (N2oEnum.class.isAssignableFrom(enumClass)) {
                element.setAttribute(new Attribute(name, ((N2oEnum)getter.get()).getId()));
            } else {
                element.setAttribute(new Attribute(name, ((Enum)getter.get()).name()));
            }
        }
    }

    public void element(Element element, String name, Supplier<String> getter, Consumer<String> setter) {
        if (this.r) {
            Element child = element.getChild(name, element.getNamespace());
            if (child != null && child.getValue() != null && !child.getValue().isEmpty()) {
                setter.accept(this.process(child.getValue()));
            }
        } else {
            if (getter.get() == null || getter.get().isEmpty()) {
                return;
            }
            Element childElement = element.getChild(name, element.getNamespace());
            if (childElement == null) {
                childElement = new Element(name, element.getNamespace());
                childElement.setText(getter.get());
                element.addContent((Content)childElement);
            } else {
                childElement.setText(getter.get());
            }
        }
    }

    public void hasElement(Element element, String name, BooleanSupplier getter, Consumer<Boolean> setter) {
        if (this.r) {
            Element child = element.getChild(name, element.getNamespace());
            setter.accept(child != null);
        } else {
            if (!getter.getAsBoolean()) {
                return;
            }
            if (element.getChild(name, element.getNamespace()) == null) {
                Element childElement = new Element(name, element.getNamespace());
                element.addContent((Content)childElement);
            }
        }
    }

    public <T, R extends TypedElementReader<? extends T>, P extends TypedElementPersister<? super T>> ElementIOFactory<T, R, P> oneOf(Class<T> baseElementClass) {
        return new ElementIOFactoryByMap(baseElementClass);
    }

    public <T extends NamespaceUriAware, R extends NamespaceReader<? extends T>, P extends NamespacePersister<? super T>> NamespaceIOFactory<T, R, P> anyOf(Class<T> baseElementClass) {
        return new NamespaceIOFactoryByMap(baseElementClass, this.readerFactory, this.persisterFactory);
    }

    public <T extends NamespaceUriAware, R extends NamespaceReader<? extends T>, P extends NamespacePersister<? super T>> NamespaceIOFactory<T, R, P> anyOf() {
        return new NamespaceIOFactoryByMap(null, this.readerFactory, this.persisterFactory);
    }

    public void additionalNamespaces(Element element, Supplier<List<Namespace>> getter, Consumer<List<Namespace>> setter) {
        if (this.r) {
            setter.accept(element.getAdditionalNamespaces());
        } else {
            if (getter.get() == null) {
                return;
            }
            for (Namespace namespace : getter.get()) {
                element.addNamespaceDeclaration(namespace);
            }
        }
    }

    private void installNamespace(Element element, Namespace namespace) {
        if (element.getNamespace().equals((Object)Namespace.NO_NAMESPACE)) {
            element.setNamespace(namespace);
            for (Object o : element.getChildren()) {
                Element child = (Element)o;
                this.installNamespace(child, namespace);
            }
        }
    }

    private void installNamespace(Element element, Namespace namespace, Namespace oldNamespace) {
        if (element.getNamespace().equals((Object)oldNamespace)) {
            element.setNamespace(namespace);
            for (Object o : element.getChildren()) {
                Element child = (Element)o;
                this.installNamespace(child, namespace, oldNamespace);
            }
        }
    }

    protected String process(String text) {
        if (text == null) {
            return null;
        }
        String resolved = net.n2oapp.framework.api.StringUtils.resolveProperties((String)text, MetadataParamHolder.getParams());
        resolved = this.systemProperties == null ? resolved : net.n2oapp.framework.api.StringUtils.resolveProperties((String)resolved, arg_0 -> ((PropertyResolver)this.systemProperties).getProperty(arg_0));
        String string = resolved = this.messageSourceAccessor == null ? resolved : net.n2oapp.framework.api.StringUtils.resolveProperties((String)resolved, msg -> this.messageSourceAccessor.getMessage(msg, msg));
        if (this.failFast && net.n2oapp.framework.api.StringUtils.hasProperty((String)resolved)) {
            throw new N2oException("Cannot resolve property in '" + text + "'");
        }
        return resolved;
    }

    private static <T extends Enum<T>> T stringToEnum(String value, Class<T> enumClass) {
        if (value == null) {
            return null;
        }
        Enum res = null;
        if (N2oEnum.class.isAssignableFrom(enumClass)) {
            for (Enum enumValue : (Enum[])enumClass.getEnumConstants()) {
                N2oEnum idEnum = (N2oEnum)enumValue;
                if (!idEnum.getId().equalsIgnoreCase(value)) continue;
                res = enumValue;
            }
        } else {
            for (Enum enumValue : (Enum[])enumClass.getEnumConstants()) {
                if (!enumValue.name().equalsIgnoreCase(value)) continue;
                res = enumValue;
            }
        }
        return (T)res;
    }

    protected <T> Element persist(NamedElementIO<T> io, T entity, Namespace namespace) {
        Element element = new Element(io.getElementName(), namespace);
        io.io(element, entity, (IOProcessor)this);
        return element;
    }

    protected <T> T read(ClassedElementIO<T> io, Element element) {
        Object entity = io.newInstance(element);
        io.io(element, entity, (IOProcessor)this);
        return (T)entity;
    }

    private <T, R extends TypedElementReader<? extends T>, P extends TypedElementPersister<? super T>> T read(ElementIOFactory<T, R, P> factory, Element element) {
        TypedElementReader reader = factory.produce(element);
        if (reader != null) {
            if (reader instanceof IOProcessorAware) {
                IOProcessorAware ioProcessorAware = (IOProcessorAware)reader;
                ioProcessorAware.setIOProcessor((IOProcessor)this);
            }
            return (T)reader.read(element);
        }
        return null;
    }

    private <T, R extends TypedElementReader<? extends T>, P extends TypedElementPersister<? super T>> Element persist(ElementIOFactory<T, R, P> factory, T entity, Namespace namespace) {
        TypedElementPersister persister = factory.produce(entity);
        if (persister != null) {
            if (persister instanceof IOProcessorAware) {
                IOProcessorAware ioProcessorAware = (IOProcessorAware)persister;
                ioProcessorAware.setIOProcessor((IOProcessor)this);
            }
            return persister.persist(entity, namespace);
        }
        return null;
    }

    private <T extends NamespaceUriAware, R extends NamespaceReader<? extends T>, P extends NamespacePersister<? super T>> T read(NamespaceIOFactory<T, R, P> factory, Element element, Namespace parentNamespace, Namespace ... defaultNamespaces) {
        NamespaceReader reader = defaultNamespaces != null && defaultNamespaces.length > 0 && defaultNamespaces[0] != null && (StringUtils.hasText((String)this.getParentNameSpacePrefix(element)) || parentNamespace.getURI().equals(element.getNamespaceURI())) ? factory.produce(element, parentNamespace, (Namespace[])ArrayUtils.add((Object[])defaultNamespaces, (Object)element.getNamespace())) : factory.produce(element, parentNamespace, null);
        if (reader != null) {
            if (reader instanceof IOProcessorAware) {
                IOProcessorAware ioProcessorAware = (IOProcessorAware)reader;
                ioProcessorAware.setIOProcessor((IOProcessor)this);
            }
            NamespaceUriAware model = (NamespaceUriAware)reader.read(element);
            model.setNamespaceUri(element.getNamespaceURI());
            model.setNamespacePrefix(element.getNamespacePrefix());
            return (T)model;
        }
        return null;
    }

    private <T extends NamespaceUriAware, R extends NamespaceReader<? extends T>, P extends NamespacePersister<? super T>> Element persist(NamespaceIOFactory<T, R, P> factory, T entity, Namespace parentNamespace, Namespace ... defaultNamespaces) {
        NamespacePersister persister = defaultNamespaces != null && defaultNamespaces.length > 0 && defaultNamespaces[0] != null && (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)entity.getNamespacePrefix()) || entity.getNamespaceUri().equals(parentNamespace.getURI())) ? factory.produce(entity.getClass(), (Namespace[])ArrayUtils.add((Object[])defaultNamespaces, (Object)entity.getNamespace())) : factory.produce(entity);
        if (persister != null) {
            if (persister instanceof IOProcessorAware) {
                IOProcessorAware ioProcessorAware = (IOProcessorAware)persister;
                ioProcessorAware.setIOProcessor((IOProcessor)this);
            }
            Element element = persister.persist(entity, parentNamespace);
            this.installNamespace(element, entity.getNamespace(), element.getNamespace());
            return element;
        }
        return null;
    }

    private String getParentNameSpacePrefix(Element element) {
        if (Objects.isNull(element)) {
            return null;
        }
        return Objects.nonNull(element.getParentElement()) ? element.getParentElement().getNamespacePrefix() : null;
    }

    private Element initSequenceElement(Element parent, String seqName) {
        Element seqE = parent.getChild(seqName, parent.getNamespace());
        if (seqE == null) {
            seqE = new Element(seqName, parent.getNamespace());
            parent.addContent((Content)seqE);
        }
        return seqE;
    }

    private void text(Element element, Supplier<String> getter, Consumer<String> setter, Function<String, String> function) {
        if (this.r) {
            this.checkCDataContent(element);
            String text = element.getText();
            if (text != null && !text.isEmpty()) {
                setter.accept(function.apply(text));
            }
        } else {
            this.setterText(element, getter);
        }
    }

    private void childrenText(Element element, String childName, Supplier<String> getter, Consumer<String> setter, Function<String, String> function) {
        if (this.r) {
            Element child = element.getChild(childName, element.getNamespace());
            if (child == null) {
                return;
            }
            this.checkCDataContent(child);
            String text = child.getText();
            if (text != null && !text.isEmpty()) {
                setter.accept(function.apply(text));
            }
        } else {
            this.setterChildText(element, childName, getter);
        }
    }

    private void setterText(Element element, Supplier<String> getter) {
        if (getter.get() == null) {
            return;
        }
        element.setText(getter.get());
    }

    private void setterChildText(Element element, String childName, Supplier<String> getter) {
        if (getter.get() == null) {
            return;
        }
        Element childElement = element.getChild(childName, element.getNamespace());
        if (childElement == null) {
            childElement = new Element(childName, element.getNamespace());
            childElement.setText(getter.get());
            element.addContent((Content)childElement);
        } else {
            childElement.setText(getter.get());
        }
    }

    private void checkCDataContent(Element element) {
        if (CollectionUtils.isEmpty((Collection)element.getContent())) {
            return;
        }
        element.getContent().stream().filter(c -> Content.CType.CDATA.equals((Object)c.getCType())).forEach(c -> {
            if (!XML_ESCAPE_SYMBOLS.matcher(c.getValue()).find()) {
                log.warn("JS \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u0430 {} \u043e\u0431\u0435\u0440\u043d\u0443\u0442\u043e \u0432 CDATA, \u043d\u043e \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0441\u043f\u0435\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0445 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432", (Object)element.getName());
            }
        });
    }

    public void setMessageSourceAccessor(MessageSourceAccessor messageSourceAccessor) {
        this.messageSourceAccessor = messageSourceAccessor;
    }

    public void setSystemProperties(PropertyResolver systemProperties) {
        this.systemProperties = systemProperties;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    public <T extends RefIdAware> void merge(T source, String elementName) {
        MergeUtil.merge(source, this.environment, elementName);
    }

    public MetadataEnvironment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(MetadataEnvironment environment) {
        this.environment = environment;
    }

    @Generated
    public boolean isR() {
        return this.r;
    }
}

