/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.compile.pipeline.operation;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Supplier;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.MetadataEnvironment;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.SourceMetadata;
import net.n2oapp.framework.api.metadata.aware.MetadataEnvironmentAware;
import net.n2oapp.framework.api.metadata.aware.PipelineOperationTypeAware;
import net.n2oapp.framework.api.metadata.compile.BindProcessor;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.SourceProcessor;
import net.n2oapp.framework.api.metadata.pipeline.PipelineOperation;
import net.n2oapp.framework.api.metadata.pipeline.PipelineOperationTypeEnum;

public class DeserializeOperation<D extends SourceMetadata>
implements PipelineOperation<D, InputStream>,
PipelineOperationTypeAware,
MetadataEnvironmentAware {
    private ObjectMapper mapper;

    public DeserializeOperation() {
    }

    public DeserializeOperation(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public D execute(CompileContext<?, ?> context, DataSet data, Supplier<InputStream> supplier, CompileProcessor compileProcessor, BindProcessor bindProcessor, SourceProcessor sourceProcessor) {
        try (InputStream value = supplier.get();){
            SourceMetadata sourceMetadata = (SourceMetadata)this.mapper.readValue(value, context.getSourceClass());
            return (D)sourceMetadata;
        }
        catch (IOException e) {
            throw new N2oException("Error during deserialize json to " + String.valueOf(context.getSourceClass()), (Throwable)e);
        }
    }

    public PipelineOperationTypeEnum getPipelineOperationType() {
        return PipelineOperationTypeEnum.DESERIALIZE;
    }

    public void setEnvironment(MetadataEnvironment environment) {
        this.mapper = environment.getSerializeObjectMapper();
    }
}

