/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.compile.pipeline;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.MetadataEnvironment;
import net.n2oapp.framework.api.metadata.Compiled;
import net.n2oapp.framework.api.metadata.SourceMetadata;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.SourceProcessor;
import net.n2oapp.framework.api.metadata.pipeline.PipelineOperationTypeEnum;
import net.n2oapp.framework.api.metadata.pipeline.ReadCompileBindTerminalPipeline;
import net.n2oapp.framework.api.metadata.pipeline.ReadCompileTerminalPipeline;
import net.n2oapp.framework.api.metadata.pipeline.ReadPersistTerminalPipeline;
import net.n2oapp.framework.api.metadata.pipeline.ReadPipeline;
import net.n2oapp.framework.api.metadata.pipeline.ReadSerializeTerminalPipeline;
import net.n2oapp.framework.api.metadata.pipeline.ReadTerminalPipeline;
import net.n2oapp.framework.api.register.MetaType;
import net.n2oapp.framework.api.util.SubModelsProcessor;
import net.n2oapp.framework.config.compile.pipeline.DummyCompileContext;
import net.n2oapp.framework.config.compile.pipeline.N2oPipeline;
import net.n2oapp.framework.config.metadata.compile.N2oCompileProcessor;
import net.n2oapp.framework.config.register.storage.PathUtil;
import net.n2oapp.framework.config.util.FileSystemUtil;
import org.apache.commons.io.IOUtils;

public class N2oReadPipeline
extends N2oPipeline
implements ReadPipeline {
    protected N2oReadPipeline(MetadataEnvironment env) {
        super(env);
    }

    public ReadTerminalPipeline<ReadCompileTerminalPipeline<ReadCompileBindTerminalPipeline>> read() {
        this.pullOp(PipelineOperationTypeEnum.READ);
        return new ReadTerminalPipeline<ReadCompileTerminalPipeline<ReadCompileBindTerminalPipeline>>(){

            public <S extends SourceMetadata> S get(String id, Class<S> sourceClass) {
                return (S)((SourceMetadata)N2oReadPipeline.this.execute(new DummyCompileContext<S>(id, sourceClass), null, null));
            }

            public <S extends SourceMetadata> S get(String id, Class<S> sourceClass, SourceProcessor p) {
                return (S)((SourceMetadata)N2oReadPipeline.this.execute(N2oReadPipeline.this.ops(), new DummyCompileContext<S>(id, sourceClass), null, null, null, null, p));
            }

            public ReadPersistTerminalPipeline persist() {
                N2oReadPipeline.this.pullOp(PipelineOperationTypeEnum.PERSIST);
                return new ReadPersistTerminalPipeline(){

                    public <S extends SourceMetadata> InputStream get(String id, Class<S> sourceClass) {
                        return (InputStream)N2oReadPipeline.this.execute(new DummyCompileContext<S>(id, sourceClass), null, null);
                    }

                    public <S extends SourceMetadata> void set(String id, Class<S> sourceClass, OutputStream output) {
                        try (InputStream is = this.get(id, sourceClass);){
                            IOUtils.copy((InputStream)is, (OutputStream)output);
                        }
                        catch (IOException e) {
                            throw new IllegalStateException(e);
                        }
                    }

                    public <S extends SourceMetadata> void set(String id, MetaType metaType, String directory) {
                        String path = PathUtil.concatFileNameAndBasePath(id + "." + metaType.getSourceType() + ".xml", directory);
                        FileSystemUtil.saveContentToFile(this.get(id, metaType.getBaseSourceClass()), new File(path));
                    }
                };
            }

            public ReadSerializeTerminalPipeline serialize() {
                N2oReadPipeline.this.pullOp(PipelineOperationTypeEnum.SERIALIZE);
                return new ReadSerializeTerminalPipeline(){

                    public <S extends SourceMetadata> InputStream get(String id, Class<S> sourceClass) {
                        return (InputStream)N2oReadPipeline.this.execute(new DummyCompileContext<S>(id, sourceClass), null, null);
                    }

                    public <S extends SourceMetadata> void set(String id, Class<S> sourceClass, OutputStream output) {
                        try (InputStream is = this.get(id, sourceClass);){
                            IOUtils.copy((InputStream)is, (OutputStream)output);
                        }
                        catch (IOException e) {
                            throw new IllegalStateException(e);
                        }
                    }
                };
            }

            public ReadCompileTerminalPipeline<ReadCompileBindTerminalPipeline> compile() {
                N2oReadPipeline.this.pullOp(PipelineOperationTypeEnum.COMPILE);
                return new ReadCompileTerminalPipeline<ReadCompileBindTerminalPipeline>(){

                    public <D extends Compiled> D get(CompileContext<D, ?> ctx) {
                        return (D)((Compiled)N2oReadPipeline.this.execute(ctx, null, null, null));
                    }

                    public <D extends Compiled> D get(CompileContext<D, ?> ctx, CompileProcessor p) {
                        return (D)((Compiled)N2oReadPipeline.this.execute(ctx, null, null, p, (N2oCompileProcessor)p, (N2oCompileProcessor)p));
                    }

                    public ReadCompileBindTerminalPipeline bind() {
                        N2oReadPipeline.this.pullOp(PipelineOperationTypeEnum.BIND);
                        return new ReadCompileBindTerminalPipeline(){

                            public <D extends Compiled> D get(CompileContext<D, ?> context, DataSet data) {
                                return (D)((Compiled)N2oReadPipeline.this.execute(context, data, null));
                            }

                            public <D extends Compiled> D get(CompileContext<D, ?> context, DataSet data, SubModelsProcessor subModelsProcessor) {
                                return (D)((Compiled)N2oReadPipeline.this.execute(context, data, null, subModelsProcessor, null));
                            }

                            public ReadCompileBindTerminalPipeline bind() {
                                N2oReadPipeline.this.pullOp(PipelineOperationTypeEnum.BIND);
                                return this;
                            }
                        };
                    }

                    public ReadCompileTerminalPipeline<ReadCompileBindTerminalPipeline> transform() {
                        N2oReadPipeline.this.pullOp(PipelineOperationTypeEnum.COMPILE_TRANSFORM);
                        return this;
                    }

                    public ReadCompileTerminalPipeline<ReadCompileBindTerminalPipeline> cache() {
                        N2oReadPipeline.this.pullOp(PipelineOperationTypeEnum.COMPILE_CACHE);
                        return this;
                    }

                    public ReadCompileTerminalPipeline<ReadCompileBindTerminalPipeline> copy() {
                        N2oReadPipeline.this.pullOp(PipelineOperationTypeEnum.COPY);
                        return this;
                    }
                };
            }

            public ReadTerminalPipeline<ReadCompileTerminalPipeline<ReadCompileBindTerminalPipeline>> validate() {
                N2oReadPipeline.this.pullOp(PipelineOperationTypeEnum.VALIDATE);
                return this;
            }

            public ReadTerminalPipeline<ReadCompileTerminalPipeline<ReadCompileBindTerminalPipeline>> merge() {
                N2oReadPipeline.this.pullOp(PipelineOperationTypeEnum.MERGE);
                return this;
            }

            public ReadTerminalPipeline<ReadCompileTerminalPipeline<ReadCompileBindTerminalPipeline>> transform() {
                N2oReadPipeline.this.pullOp(PipelineOperationTypeEnum.SOURCE_TRANSFORM);
                return this;
            }

            public ReadTerminalPipeline<ReadCompileTerminalPipeline<ReadCompileBindTerminalPipeline>> cache() {
                N2oReadPipeline.this.pullOp(PipelineOperationTypeEnum.SOURCE_CACHE);
                return this;
            }

            public ReadTerminalPipeline<ReadCompileTerminalPipeline<ReadCompileBindTerminalPipeline>> copy() {
                N2oReadPipeline.this.pullOp(PipelineOperationTypeEnum.COPY);
                return this;
            }
        };
    }
}

