/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.util;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class StylesResolver {
    private StylesResolver() {
    }

    public static Map<String, String> resolveStyles(String input) {
        String[] lines;
        if (input == null || input.trim().length() == 0) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (String line : lines = input.trim().split(";")) {
            String[] lineArr = line.split(":");
            if (lineArr.length != 2) {
                throw new IllegalArgumentException("Invalid string of styles");
            }
            String key = StylesResolver.kebabToCamelCase(lineArr[0].replaceAll("[\\t ]", ""));
            String value = lineArr[1];
            while (value.startsWith(" ")) {
                value = value.replaceFirst("[\\t ]", "");
            }
            result.put(key, value);
        }
        return result;
    }

    public static String resolveStylesToString(String input) {
        if (input == null) {
            return null;
        }
        Map<String, String> styleMap = StylesResolver.resolveStyles(input);
        if (styleMap == null) {
            return null;
        }
        return styleMap.keySet().stream().map(key -> key + ":" + (String)styleMap.get(key)).collect(Collectors.joining(";"));
    }

    private static String kebabToCamelCase(String s) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '-' && i + 1 < s.length()) {
                builder.append(Character.toUpperCase(s.charAt(++i)));
                continue;
            }
            builder.append(s.charAt(i));
        }
        return builder.toString();
    }

    public static String camelToSnake(Object camelCase) {
        if (camelCase == null) {
            return null;
        }
        return StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)camelCase.toString()), (String)"_").toUpperCase();
    }
}

